/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.ExactIndexBasedStartClause;
import org.springframework.data.neo4j.repository.query.FullTextIndexBasedStartClause;
import org.springframework.data.neo4j.repository.query.GraphIdStartClause;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.repository.query.StartClause;
import org.springframework.data.neo4j.repository.query.StartClauseFactory;
import org.springframework.data.repository.query.parser.Part;

public class StartClauseFactoryTest {
    PartInfo simpleIndexedPartInfo1;
    PartInfo simpleIndexedPartInfo2;
    PartInfo searchableIndexedPartInfo;
    PartInfo fullTextIndexedPartInfo;
    PartInfo idBasedPartInfo;
    PartInfo relBasedPartInfo;

    @Before
    public void setUp() throws Exception {
        this.simpleIndexedPartInfo1 = (PartInfo)Mockito.mock(PartInfo.class);
        Mockito.when((Object)this.simpleIndexedPartInfo1.isIndexed()).thenReturn((Object)true);
        Mockito.when((Object)this.simpleIndexedPartInfo1.isFullText()).thenReturn((Object)false);
        this.simpleIndexedPartInfo2 = (PartInfo)Mockito.mock(PartInfo.class);
        Mockito.when((Object)this.simpleIndexedPartInfo2.isIndexed()).thenReturn((Object)true);
        Mockito.when((Object)this.simpleIndexedPartInfo2.isFullText()).thenReturn((Object)false);
        this.searchableIndexedPartInfo = (PartInfo)Mockito.mock(PartInfo.class);
        Mockito.when((Object)this.searchableIndexedPartInfo.isIndexed()).thenReturn((Object)true);
        Mockito.when((Object)this.searchableIndexedPartInfo.isFullText()).thenReturn((Object)false);
        Mockito.when((Object)this.searchableIndexedPartInfo.getType()).thenReturn((Object)Part.Type.STARTING_WITH);
        this.fullTextIndexedPartInfo = (PartInfo)Mockito.mock(PartInfo.class);
        Mockito.when((Object)this.fullTextIndexedPartInfo.isIndexed()).thenReturn((Object)true);
        Mockito.when((Object)this.fullTextIndexedPartInfo.isFullText()).thenReturn((Object)true);
        Neo4jPersistentProperty leafProperty1 = (Neo4jPersistentProperty)Mockito.mock(Neo4jPersistentProperty.class);
        this.idBasedPartInfo = (PartInfo)Mockito.mock(PartInfo.class);
        Mockito.when((Object)this.idBasedPartInfo.isIndexed()).thenReturn((Object)false);
        Mockito.when((Object)this.idBasedPartInfo.getLeafProperty()).thenReturn((Object)leafProperty1);
        Mockito.when((Object)leafProperty1.isRelationship()).thenReturn((Object)false);
        Mockito.when((Object)leafProperty1.isIdProperty()).thenReturn((Object)true);
        Neo4jPersistentProperty leafProperty2 = (Neo4jPersistentProperty)Mockito.mock(Neo4jPersistentProperty.class);
        this.relBasedPartInfo = (PartInfo)Mockito.mock(PartInfo.class);
        Mockito.when((Object)this.relBasedPartInfo.isIndexed()).thenReturn((Object)false);
        Mockito.when((Object)this.relBasedPartInfo.getLeafProperty()).thenReturn((Object)leafProperty2);
        Mockito.when((Object)leafProperty2.isRelationship()).thenReturn((Object)true);
        Mockito.when((Object)leafProperty2.isIdProperty()).thenReturn((Object)false);
    }

    @Test
    public void testCreateExactIndexBasedStartClause() {
        StartClause startClause = StartClauseFactory.create((PartInfo)this.simpleIndexedPartInfo1);
        Assert.assertTrue((boolean)(startClause instanceof ExactIndexBasedStartClause));
    }

    @Test
    public void testCreateFullTextIndexBasedStartClauseWhenFullyIndexed() {
        StartClause startClause = StartClauseFactory.create((PartInfo)this.fullTextIndexedPartInfo);
        Assert.assertTrue((boolean)(startClause instanceof FullTextIndexBasedStartClause));
    }

    @Test
    public void testCreateFullTextIndexBasedStartClauseWhenNormallyIndexedButWithSearchLikePart() {
        StartClause startClause = StartClauseFactory.create((PartInfo)this.searchableIndexedPartInfo);
        Assert.assertTrue((boolean)(startClause instanceof FullTextIndexBasedStartClause));
    }

    @Test
    public void testCreateGraphIdStartClauseWhenIdPropertyPathInfo() {
        StartClause startClause = StartClauseFactory.create((PartInfo)this.idBasedPartInfo);
        Assert.assertTrue((boolean)(startClause instanceof GraphIdStartClause));
    }

    @Test
    public void testCreateGraphIdStartClauseWhenIsRelationship() {
        StartClause startClause = StartClauseFactory.create((PartInfo)this.relBasedPartInfo);
        Assert.assertTrue((boolean)(startClause instanceof GraphIdStartClause));
    }

    @Test
    public void testCreateFullTextIndexBasedStartClauseWhenMultiplePartsProvidedWhichAreAllIndexedWithSameId() {
        ArrayList<PartInfo> partInfos = new ArrayList<PartInfo>();
        partInfos.add(this.simpleIndexedPartInfo1);
        partInfos.add(this.simpleIndexedPartInfo2);
        Mockito.when((Object)this.simpleIndexedPartInfo1.sameIdentifier(this.simpleIndexedPartInfo1)).thenReturn((Object)true);
        Mockito.when((Object)this.simpleIndexedPartInfo2.sameIdentifier(this.simpleIndexedPartInfo1)).thenReturn((Object)true);
        StartClause startClause = StartClauseFactory.create(partInfos);
        Assert.assertTrue((boolean)(startClause instanceof FullTextIndexBasedStartClause));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExceptionThrownWhenProvidingMultiplePartsWhichAreAllIndexedButDiffId() {
        ArrayList<PartInfo> partInfos = new ArrayList<PartInfo>();
        partInfos.add(this.simpleIndexedPartInfo1);
        partInfos.add(this.simpleIndexedPartInfo2);
        Mockito.when((Object)this.simpleIndexedPartInfo1.sameIdentifier(this.simpleIndexedPartInfo1)).thenReturn((Object)true);
        Mockito.when((Object)this.simpleIndexedPartInfo2.sameIdentifier(this.simpleIndexedPartInfo1)).thenReturn((Object)false);
        StartClauseFactory.create(partInfos);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExceptionThrownWhenProvidingMultiplePartsWhichAreNotAllIndexed() {
        ArrayList<PartInfo> partInfos = new ArrayList<PartInfo>();
        partInfos.add(this.simpleIndexedPartInfo1);
        partInfos.add(this.idBasedPartInfo);
        Mockito.when((Object)this.simpleIndexedPartInfo1.sameIdentifier(this.simpleIndexedPartInfo1)).thenReturn((Object)true);
        StartClauseFactory.create(partInfos);
    }
}

