/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.cypher;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.repository.query.cypher.DateEntity;
import org.springframework.data.neo4j.repository.query.cypher.DateEntityRepository;
import org.springframework.data.neo4j.repository.query.cypher.Dates;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
public class InParameterisedByDateTests {
    @Autowired
    GraphDatabaseService graphDatabaseService;
    @Autowired
    DateEntityRepository dateEntityRepository;

    @Before
    public void before() {
        Neo4jHelper.cleanDb(this.graphDatabaseService, true);
        Transaction transaction = this.graphDatabaseService.beginTx();
        try {
            this.dateEntityRepository.save(new DateEntity(Dates.TODAY, new Date[]{Dates.TODAY, Dates.TOMORROW}));
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    @Test
    public void shouldSupportSingleDateAsParameterForIn() throws Exception {
        Assert.assertThat((Object)this.dateEntityRepository.findUsingDate((Date)Dates.TODAY).date, (Matcher)CoreMatchers.is((Object)Dates.TODAY));
    }

    @Test
    public void shouldSupportArrayOfDateAsParameterForIn() throws Exception {
        Assert.assertThat((Object)this.dateEntityRepository.findUsingArrayOfDate((Date[])new Date[]{Dates.TODAY}).date, (Matcher)CoreMatchers.is((Object)Dates.TODAY));
        Assert.assertThat((Object)this.dateEntityRepository.findUsingArrayOfDate((Date[])new Date[]{Dates.TODAY, Dates.TOMORROW}).date, (Matcher)CoreMatchers.is((Object)Dates.TODAY));
    }

    @Test
    public void shouldSupportArrayOfArrayOfDateAsParameterForIn() throws Exception {
        List<Date[]> dates = Arrays.asList({Dates.TODAY, Dates.TOMORROW}, {Dates.YESTERDAY});
        Assert.assertThat((Object)this.dateEntityRepository.findUsingArrayOfArrayOfDate(dates).date, (Matcher)CoreMatchers.is((Object)Dates.TODAY));
    }

    @Configuration
    @EnableNeo4jRepositories
    static class TestConfig
    extends Neo4jConfiguration {
        TestConfig() throws ClassNotFoundException {
            this.setBasePackage(new String[]{DateEntity.class.getPackage().getName()});
        }

        @Bean
        GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }
    }
}

