/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.cypher;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.repository.query.cypher.EnumEntity;
import org.springframework.data.neo4j.repository.query.cypher.EnumEntityRepository;
import org.springframework.data.neo4j.repository.query.cypher.Suit;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
public class InParameterisedByEnumTests {
    @Autowired
    GraphDatabaseService graphDatabaseService;
    @Autowired
    EnumEntityRepository enumEntityRepository;

    @Before
    public void before() {
        Neo4jHelper.cleanDb(this.graphDatabaseService, true);
        Transaction transaction = this.graphDatabaseService.beginTx();
        try {
            this.enumEntityRepository.save(new EnumEntity(Suit.SPADE));
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    @Test
    public void shouldSupportSingleEnumsAsParameterForIn() throws Exception {
        Assert.assertThat((Object)((Object)this.enumEntityRepository.findUsingEnum((Suit)Suit.SPADE).suit), (Matcher)CoreMatchers.is((Object)((Object)Suit.SPADE)));
    }

    @Test
    public void shouldSupportArrayOfEnumAsParameterForIn() throws Exception {
        Assert.assertThat((Object)((Object)this.enumEntityRepository.findUsingArrayOfEnum((Suit[])new Suit[]{Suit.SPADE}).suit), (Matcher)CoreMatchers.is((Object)((Object)Suit.SPADE)));
        Assert.assertThat((Object)((Object)this.enumEntityRepository.findUsingArrayOfEnum((Suit[])new Suit[]{Suit.SPADE, Suit.HEART}).suit), (Matcher)CoreMatchers.is((Object)((Object)Suit.SPADE)));
    }

    @Test
    public void shouldSupportArrayOfArrayOfEnumAsParameterForIn() throws Exception {
        Assert.assertThat((Object)((Object)this.enumEntityRepository.findUsingArrayOfArrayOfString(Arrays.asList(new String[][]{{"CLUB", "DIAMOND", "HEART"}, {"SPADE", "DIAMOND"}})).suit), (Matcher)CoreMatchers.is((Object)((Object)Suit.SPADE)));
        Assert.assertThat((Object)((Object)this.enumEntityRepository.findUsingArrayOfArrayOfEnum(Arrays.asList(new Suit[][]{{Suit.CLUB, Suit.DIAMOND, Suit.HEART}, {Suit.SPADE, Suit.DIAMOND}})).suit), (Matcher)CoreMatchers.is((Object)((Object)Suit.SPADE)));
    }

    @Configuration
    @EnableNeo4jRepositories
    static class TestConfig
    extends Neo4jConfiguration {
        TestConfig() throws ClassNotFoundException {
            this.setBasePackage(new String[]{EnumEntity.class.getPackage().getName()});
        }

        @Bean
        GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }
    }
}

