/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.cypher;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.repository.query.cypher.SimpleTypeEntity;
import org.springframework.data.neo4j.repository.query.cypher.SimpleTypeEntityRepository;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
public class InParameterisedBySimpleTypeTests {
    public static final byte BYTE = 66;
    public static final boolean BOOLEAN = true;
    public static final short SHORT = 23;
    public static final int INT = 63;
    public static final long LONG = 87L;
    public static final float FLOAT = 3.14f;
    public static final double DOUBLE = 2.97;
    public static final char CHAR = '!';
    public static final String STRING = "dub";
    @Autowired
    GraphDatabaseService graphDatabaseService;
    @Autowired
    SimpleTypeEntityRepository simpleTypeEntityRepository;

    @Before
    public void before() {
        Neo4jHelper.cleanDb(this.graphDatabaseService, true);
        Transaction transaction = this.graphDatabaseService.beginTx();
        try {
            this.simpleTypeEntityRepository.save(new SimpleTypeEntity());
            this.simpleTypeEntityRepository.save(new SimpleTypeEntity(true, 66, 23, 63, 87L, 3.14f, 2.97, '!', STRING));
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    @Test
    public void shouldSupportSimpleTypesAsParametersForIn() throws Exception {
        Assert.assertThat((Object)this.simpleTypeEntityRepository.findUsingBoolean((boolean[])new boolean[]{true}).aBoolean, (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.simpleTypeEntityRepository.findUsingByte((byte[])new byte[]{66}).aByte, (Matcher)CoreMatchers.is((Object)66));
        Assert.assertThat((Object)this.simpleTypeEntityRepository.findUsingShort((short[])new short[]{23}).aShort, (Matcher)CoreMatchers.is((Object)23));
        Assert.assertThat((Object)this.simpleTypeEntityRepository.findUsingInt((int[])new int[]{63}).anInt, (Matcher)CoreMatchers.is((Object)63));
        Assert.assertThat((Object)this.simpleTypeEntityRepository.findUsingLong((long[])new long[]{87L}).aLong, (Matcher)CoreMatchers.is((Object)87L));
        Assert.assertThat((Object)Float.valueOf(this.simpleTypeEntityRepository.findUsingFloat((float[])new float[]{3.14f}).aFloat), (Matcher)CoreMatchers.is((Object)Float.valueOf(3.14f)));
        Assert.assertThat((Object)this.simpleTypeEntityRepository.findUsingDouble((double[])new double[]{2.97}).aDouble, (Matcher)CoreMatchers.is((Object)2.97));
        Assert.assertThat((Object)Character.valueOf(this.simpleTypeEntityRepository.findUsingChar((char[])new char[]{'!'}).aChar), (Matcher)CoreMatchers.is((Object)Character.valueOf('!')));
        Assert.assertThat((Object)this.simpleTypeEntityRepository.findUsingString((String[])new String[]{STRING}).aString, (Matcher)CoreMatchers.is((Object)STRING));
    }

    @Configuration
    @EnableNeo4jRepositories
    static class TestConfig
    extends Neo4jConfiguration {
        TestConfig() throws ClassNotFoundException {
            this.setBasePackage(new String[]{SimpleTypeEntity.class.getPackage().getName()});
        }

        @Bean
        GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }
    }
}

