/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.support.DelegatingGraphDatabase;
import org.springframework.data.neo4j.support.schema.SchemaIndexProvider;

public class DelegatingGraphDatabaseTests {
    private DelegatingGraphDatabase graphDatabase;
    private GraphDatabaseService gdb;

    @Before
    public void setUp() throws Exception {
        this.gdb = new TestGraphDatabaseFactory().newImpermanentDatabase();
        this.graphDatabase = new DelegatingGraphDatabase(this.gdb);
    }

    @After
    public void tearDown() throws Exception {
        this.graphDatabase.shutdown();
    }

    @Test
    public void testGetOrCreateNode() throws Exception {
        try (Transaction tx = this.graphDatabase.beginTx();){
            Node node = this.graphDatabase.getOrCreateNode("user", "name", (Object)"David", MapUtil.map((Object[])new Object[]{"name", "David"}), null);
            Node node2 = this.graphDatabase.getOrCreateNode("user", "name", (Object)"David", MapUtil.map((Object[])new Object[]{"name", "David"}), null);
            Assert.assertEquals((Object)"David", (Object)node.getProperty("name"));
            Assert.assertEquals((Object)node, (Object)node2);
            Assert.assertEquals((Object)node, (Object)this.gdb.index().forNodes("user").get("name", (Object)"David").getSingle());
            tx.success();
        }
    }

    @Test
    public void mergeNode() throws Exception {
        new SchemaIndexProvider((GraphDatabase)this.graphDatabase).createIndex("user", "name", true);
        try (Transaction tx = this.graphDatabase.beginTx();){
            Node node = this.graphDatabase.merge("user", "name", (Object)"David", MapUtil.map((Object[])new Object[]{"name", "David"}), null);
            Node node2 = this.graphDatabase.merge("user", "name", (Object)"David", MapUtil.map((Object[])new Object[]{"name", "David"}), null);
            Assert.assertEquals((Object)"David", (Object)node.getProperty("name"));
            Assert.assertEquals((Object)node, (Object)node2);
            Assert.assertEquals((Object)node, (Object)IteratorUtil.singleOrNull((Iterable)this.gdb.findNodesByLabelAndProperty(DynamicLabel.label((String)"user"), "name", (Object)"David")));
            tx.success();
        }
    }

    @Test
    public void mergeNodeWithLabel() throws Exception {
        new SchemaIndexProvider((GraphDatabase)this.graphDatabase).createIndex("user", "name", true);
        try (Transaction tx = this.graphDatabase.beginTx();){
            Node node = this.graphDatabase.merge("user", "name", (Object)"David", MapUtil.map((Object[])new Object[]{"name", "David"}), Arrays.asList("person"));
            Assert.assertEquals((Object)"David", (Object)node.getProperty("name"));
            Assert.assertEquals((long)2L, (long)IteratorUtil.count((Iterable)node.getLabels()));
            for (Label label : node.getLabels()) {
                Assert.assertEquals((Object)true, (Object)Arrays.asList("user", "person").contains(label.name()));
            }
            Assert.assertEquals((Object)node, (Object)IteratorUtil.singleOrNull((Iterable)this.gdb.findNodesByLabelAndProperty(DynamicLabel.label((String)"user"), "name", (Object)"David")));
            tx.success();
        }
    }

    @Test
    public void testGetOrCreateRelationship() throws Exception {
        try (Transaction tx = this.graphDatabase.beginTx();){
            Node david = this.graphDatabase.createNode(MapUtil.map((Object[])new Object[]{"name", "David"}), Arrays.asList("Person"));
            Node michael = this.graphDatabase.createNode(MapUtil.map((Object[])new Object[]{"name", "Michael"}), Arrays.asList("Person"));
            Relationship rel1 = this.graphDatabase.getOrCreateRelationship("knows", "whom", (Object)"david_michael", david, michael, "KNOWS", MapUtil.map((Object[])new Object[]{"whom", "david_michael"}));
            Relationship rel2 = this.graphDatabase.getOrCreateRelationship("knows", "whom", (Object)"david_michael", david, michael, "KNOWS", MapUtil.map((Object[])new Object[]{"whom", "david_michael"}));
            Assert.assertEquals((Object)"david_michael", (Object)rel1.getProperty("whom"));
            Assert.assertEquals((Object)"KNOWS", (Object)rel1.getType().name());
            Assert.assertEquals((Object)david, (Object)rel1.getStartNode());
            Assert.assertEquals((Object)michael, (Object)rel1.getEndNode());
            Assert.assertEquals((Object)rel1, (Object)rel2);
            Assert.assertEquals((Object)rel1, (Object)this.gdb.index().forRelationships("knows").get("whom", (Object)"david_michael").getSingle());
            tx.success();
        }
    }
}

