/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.mapping.ManagedEntity;
import org.springframework.data.neo4j.model.Account1;
import org.springframework.data.neo4j.model.Account2;
import org.springframework.data.neo4j.model.Friendship;
import org.springframework.data.neo4j.model.Group;
import org.springframework.data.neo4j.model.Named;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.support.EntityTestBase;
import org.springframework.data.neo4j.support.query.CypherQueryEngine;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:template-config-context.xml"})
public class EntityNeo4jTemplateTests
extends EntityTestBase {
    public static final DynamicRelationshipType KNOWS = DynamicRelationshipType.withName((String)"knows");
    @Autowired
    PlatformTransactionManager transactionManager;
    private Neo4jOperations neo4jOperations;

    @Before
    public void setUp() throws Exception {
        this.createTeam();
        this.neo4jOperations = this.template;
    }

    @Test
    @Transactional
    public void testRepositoryFor() throws Exception {
        GraphRepository personRepository = this.neo4jOperations.repositoryFor(Person.class);
        GraphRepository groupRepository = this.neo4jOperations.repositoryFor(Group.class);
        GraphRepository friendshipRepository = this.neo4jOperations.repositoryFor(Friendship.class);
        this.testTeam.createSDGTeam((GraphRepository<Person>)personRepository, (GraphRepository<Group>)groupRepository, (GraphRepository<Friendship>)friendshipRepository);
        Person found = (Person)personRepository.findOne((Serializable)this.testTeam.michael.getId());
        Assert.assertEquals((Object)found.getId(), (Object)this.testTeam.michael.getId());
    }

    @Test
    @Transactional
    public void testRelationshipRepositoryFor() throws Exception {
        GraphRepository friendshipRepository = this.neo4jOperations.repositoryFor(Friendship.class);
        Friendship found = (Friendship)friendshipRepository.findOne((Serializable)this.testTeam.friendShip.getId());
        Assert.assertEquals((Object)found.getId(), (Object)this.testTeam.friendShip.getId());
    }

    @Test
    @Transactional
    @Ignore
    public void testGetIndexForType() throws Exception {
        Index personIndex = this.template.getIndex(Person.class);
        Assert.assertEquals((Object)"Person", (Object)personIndex.getName());
    }

    @Test
    @Transactional
    public void testGetIndexForName() throws Exception {
        Index nameIndex = this.template.getIndex("name-index");
        Assert.assertEquals((Object)"name-index", (Object)nameIndex.getName());
    }

    @Test
    @Transactional
    public void testGetIndexForNoTypeAndName() throws Exception {
        Index nameIndex = this.neo4jOperations.getIndex("name-index", null);
        Assert.assertEquals((Object)"name-index", (Object)nameIndex.getName());
    }

    @Test
    @Transactional
    @Ignore
    public void testGetIndexForTypeAndNoName() throws Exception {
        Index nameIndex = this.neo4jOperations.getIndex(null, Person.class);
        Assert.assertEquals((Object)"Person", (Object)nameIndex.getName());
    }

    @Test
    @Transactional
    public void testGetIndexForTypeAndName() throws Exception {
        Index nameIndex = this.neo4jOperations.getIndex("name-index", Person.class);
        Assert.assertEquals((Object)"name-index", (Object)nameIndex.getName());
    }

    @Test
    @Transactional
    public void testFindOne() throws Exception {
        Person found = (Person)this.neo4jOperations.findOne(this.testTeam.michael.getId().longValue(), Person.class);
        Assert.assertEquals((Object)this.testTeam.michael.getId(), (Object)found.getId());
        Assert.assertEquals((Object)this.testTeam.michael.getName(), (Object)found.getName());
    }

    @Test
    @Transactional
    public void testFindAll() throws Exception {
        Collection people = IteratorUtil.asCollection((Iterable)this.neo4jOperations.findAll(Person.class));
        Assert.assertEquals((long)3L, (long)people.size());
        Assert.assertNotNull((String)"people attributes where loaded", (Object)((Person)IteratorUtil.first((Iterable)people)).getName());
    }

    @Test
    @Transactional
    public void testCount() throws Exception {
        Assert.assertEquals((long)3L, (long)this.neo4jOperations.count(Person.class));
    }

    @Test
    @Transactional
    public void testCreateRelationshipEntityFromStoredType() throws Exception {
        Relationship friendshipRelationship = this.getRelationshipState(this.testTeam.friendShip);
        Friendship found = (Friendship)this.template.createEntityFromStoredType((PropertyContainer)friendshipRelationship, this.template.getMappingPolicy((Object)this.testTeam.michael));
        Assert.assertEquals((Object)this.testTeam.friendShip.getId(), (Object)found.getId());
    }

    @Test
    @Transactional
    public void testCreateNodeEntityFromStoredType() throws Exception {
        Node michaelNode = this.getNodeState(this.testTeam.michael);
        Person found = (Person)this.template.createEntityFromStoredType((PropertyContainer)michaelNode, this.template.getMappingPolicy((Object)this.testTeam.michael));
        Assert.assertEquals((Object)this.testTeam.michael.getId(), (Object)found.getId());
    }

    @Test
    @Transactional
    public void testCreateEntityFromState() throws Exception {
        Node michaelNode = this.getNodeState(this.testTeam.michael);
        Person found = (Person)this.template.createEntityFromStoredType((PropertyContainer)michaelNode, this.template.getMappingPolicy((Object)this.testTeam.michael));
        Assert.assertEquals((Object)this.testTeam.michael.getId(), (Object)found.getId());
    }

    @Test
    @Transactional
    public void testProjectTo() throws Exception {
        Named named = (Named)this.neo4jOperations.projectTo((Object)this.testTeam.sdg, Named.class);
        Assert.assertEquals((Object)this.testTeam.sdg.getName(), (Object)named.getName());
    }

    @Test
    @Transactional
    public void testGetPersistentState() throws Exception {
        Assert.assertEquals((Object)this.testTeam.michael.getId(), (Object)((Node)this.neo4jOperations.getPersistentState((Object)this.testTeam.michael)).getId());
    }

    @Test
    @Transactional
    public void testSetPersistentState() throws Exception {
        Person clone = new Person();
        this.template.setPersistentState((Object)clone, this.neo4jOperations.getPersistentState((Object)this.testTeam.david));
        Assert.assertEquals((Object)this.testTeam.david.getId(), (Object)clone.getId());
    }

    @Test(expected=DataRetrievalFailureException.class)
    public void testDelete() throws Exception {
        Long id = (Long)new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallback<Long>(){

            public Long doInTransaction(TransactionStatus transactionStatus) {
                Long id = EntityNeo4jTemplateTests.this.testTeam.michael.getId();
                EntityNeo4jTemplateTests.this.neo4jOperations.delete((Object)EntityNeo4jTemplateTests.this.testTeam.michael);
                return id;
            }
        });
        try (Transaction tx = this.graphDatabaseService.beginTx();){
            Assert.assertNull((Object)this.neo4jOperations.getNode(id.longValue()));
            tx.success();
        }
    }

    @Test(expected=DataRetrievalFailureException.class)
    public void testRemoveNodeEntity() throws Exception {
        Long id = (Long)new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallback<Long>(){

            public Long doInTransaction(TransactionStatus transactionStatus) {
                Long id = EntityNeo4jTemplateTests.this.testTeam.michael.getId();
                EntityNeo4jTemplateTests.this.template.delete((Object)EntityNeo4jTemplateTests.this.testTeam.michael);
                return id;
            }
        });
        try (Transaction tx = this.graphDatabaseService.beginTx();){
            Assert.assertNull((Object)this.neo4jOperations.getNode(id.longValue()));
            tx.success();
        }
    }

    @Test(expected=DataRetrievalFailureException.class)
    public void testRemoveRelationshipEntity() throws Exception {
        Long id = (Long)new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallback<Long>(){

            public Long doInTransaction(TransactionStatus transactionStatus) {
                Long id = EntityNeo4jTemplateTests.this.testTeam.friendShip.getId();
                EntityNeo4jTemplateTests.this.template.delete((Object)EntityNeo4jTemplateTests.this.testTeam.friendShip);
                return id;
            }
        });
        try (Transaction tx = this.graphDatabaseService.beginTx();){
            Assert.assertNull((Object)this.neo4jOperations.getRelationship(id.longValue()));
            tx.success();
        }
    }

    @Test
    @Transactional
    public void testCreateNodeAs() throws Exception {
        Person thomas = (Person)this.neo4jOperations.createNodeAs(Person.class, MapUtil.map((Object[])new Object[]{"name", "Thomas"}));
        Assert.assertEquals((Object)"Thomas", (Object)this.neo4jOperations.getNode(thomas.getId().longValue()).getProperty("name"));
        Person found = (Person)this.template.createEntityFromStoredType((PropertyContainer)this.getNodeState(thomas), this.template.getMappingPolicy(Person.class));
        Assert.assertEquals((Object)"Thomas", (Object)found.getName());
    }

    @Test
    @Transactional
    public void testIsNodeEntity() throws Exception {
        Assert.assertEquals((Object)true, (Object)this.template.isNodeEntity(Person.class));
        Assert.assertEquals((Object)false, (Object)this.template.isNodeEntity(Friendship.class));
        Assert.assertEquals((Object)false, (Object)this.template.isNodeEntity(Object.class));
    }

    @Test
    @Transactional
    public void testIsRelationshipEntity() throws Exception {
        Assert.assertEquals((Object)true, (Object)this.template.isRelationshipEntity(Friendship.class));
        Assert.assertEquals((Object)false, (Object)this.template.isRelationshipEntity(Person.class));
        Assert.assertEquals((Object)false, (Object)this.template.isRelationshipEntity(Object.class));
    }

    @Test
    @Transactional
    public void testDefaultCreateUniqueNodeWithFailOnDuplicateSetToFalse() throws Exception {
        Account1 acc = new Account1("111-222-333", "Mr George - Current Account");
        Node acc1Node = this.template.createUniqueNode((Object)acc);
        Node acc2Node = this.template.createUniqueNode((Object)acc);
        Assert.assertEquals((String)"When failOnDuplicate is set to false, duplicate creations should be merged to same node", (long)acc1Node.getId(), (long)acc2Node.getId());
    }

    @Test(expected=ConstraintViolationException.class)
    @Transactional
    public void testDefaultCreateUniqueNodeWithFailOnDuplicateSetToTrue() throws Exception {
        Account2 acc = new Account2("111-222-333", "Mr George - Current Account");
        Node acc1Node = this.template.createUniqueNode((Object)acc);
        Node acc2Node = this.template.createUniqueNode((Object)acc);
    }

    @Ignore(value="Not able to take failOnDuplicate into account")
    @Test
    @Transactional
    public void testCreateNodeAsIgnoresFailOnDuplicateValue() throws Exception {
        Account1 acc1 = (Account1)this.template.createNodeAs(Account1.class, MapUtil.map((Object[])new Object[]{"accountNumber", "111-222-333", "name", "Mr George - Current Account"}));
        Account1 acc2 = (Account1)this.template.createNodeAs(Account1.class, MapUtil.map((Object[])new Object[]{"accountNumber", "111-222-333", "name", "Mr George - Current Account"}));
    }

    @Test
    @Transactional
    public void testSave() throws Exception {
        Person thomas = new Person("Thomas", 30);
        this.neo4jOperations.save((Object)thomas);
        Node node = this.getNodeState(thomas);
        Assert.assertNotNull((String)"created node", (Object)node);
        Assert.assertEquals((String)"created node with id", (Object)node.getId(), (Object)thomas.getId());
        Assert.assertEquals((String)"created node with name", (Object)"Thomas", (Object)node.getProperty("name"));
    }

    @Test
    @Transactional
    public void testSaveOnly() throws Exception {
        Person thomas = new Person("Thomas", 30);
        this.neo4jOperations.saveOnly((Object)thomas);
        Node node = this.getNodeState(thomas);
        Assert.assertNotNull((String)"created node", (Object)node);
        Assert.assertEquals((String)"created node with id", (Object)node.getId(), (Object)thomas.getId());
        Assert.assertEquals((String)"created node with name", (Object)"Thomas", (Object)node.getProperty("name"));
    }

    @Test
    @Transactional
    public void testIsManaged() throws Exception {
        Assert.assertEquals((Object)true, (Object)this.template.isManaged(Mockito.mock(ManagedEntity.class)));
        Assert.assertEquals((Object)true, (Object)this.template.isManaged(Mockito.mock(ManagedTestEntity.class)));
        Assert.assertEquals((Object)false, (Object)this.template.isManaged((Object)this.testTeam.michael));
        Assert.assertEquals((Object)false, (Object)this.template.isManaged((Object)this.testTeam.friendShip));
        Assert.assertEquals((Object)false, (Object)this.template.isManaged(new Object()));
    }

    @Test
    @Transactional
    public void testQuery() throws Exception {
        Person result = (Person)this.neo4jOperations.query("start n=node({self}) return n", MapUtil.map((Object[])new Object[]{"self", this.testTeam.michael.getId()})).to(Person.class).single();
        Assert.assertEquals((Object)this.testTeam.michael.getId(), (Object)result.getId());
    }

    @Test
    @Transactional
    public void testGetRelationshipBetweenNodes() throws Exception {
        Relationship knows = this.neo4jOperations.getRelationshipBetween((Object)this.getNodeState(this.testTeam.michael), (Object)this.getNodeState(this.testTeam.david), "knows");
        Assert.assertEquals((Object)this.testTeam.friendShip.getId(), (Object)knows.getId());
    }

    @Test
    @Transactional
    public void testGetAutoPersistedRelationshipBetweenNodes() throws Exception {
        Node emilNode = this.getNodeState(this.testTeam.emil);
        Node michaelNode = this.getNodeState(this.testTeam.michael);
        Relationship boss = this.neo4jOperations.getRelationshipBetween((Object)emilNode, (Object)michaelNode, "boss");
        Assert.assertNotNull((String)"found relationship", (Object)boss);
        Assert.assertEquals((Object)michaelNode, (Object)boss.getEndNode());
        Assert.assertEquals((Object)emilNode, (Object)boss.getStartNode());
    }

    @Test
    @Transactional
    public void testGetRelationshipBetween() throws Exception {
        Friendship knows = (Friendship)this.neo4jOperations.getRelationshipBetween((Object)this.testTeam.michael, (Object)this.testTeam.david, Friendship.class, "knows");
        Assert.assertEquals((Object)this.testTeam.friendShip.getId(), (Object)knows.getId());
    }

    @Test
    @Transactional
    public void testGetMultipleRelationshipBetween() throws Exception {
        Friendship friendship = (Friendship)this.neo4jOperations.getRelationshipBetween((Object)this.testTeam.michael, (Object)this.testTeam.david, Friendship.class, "knows");
        Friendship friendship2 = (Friendship)this.neo4jOperations.createRelationshipBetween((Object)this.testTeam.michael, (Object)this.testTeam.david, Friendship.class, "knows", true);
        Iterable allFriendships = this.neo4jOperations.getRelationshipsBetween((Object)this.testTeam.michael, (Object)this.testTeam.david, Friendship.class, "knows");
        Assert.assertThat((Object)allFriendships, (Matcher)Matchers.hasItems((Object[])new Friendship[]{friendship, friendship2}));
    }

    @Test
    @Transactional
    public void testDeleteRelationshipBetween() throws Exception {
        this.neo4jOperations.deleteRelationshipBetween((Object)this.testTeam.michael, (Object)this.testTeam.david, "knows");
        Assert.assertNull((String)"relationship deleted", (Object)this.getNodeState(this.testTeam.michael).getSingleRelationship((RelationshipType)KNOWS, Direction.OUTGOING));
    }

    @Test
    @Transactional
    public void testCreateRelationshipBetweenNodes() throws Exception {
        Friendship friendship = (Friendship)this.neo4jOperations.createRelationshipBetween((Object)this.testTeam.david, (Object)this.testTeam.emil, Friendship.class, "knows", false);
        Assert.assertEquals((Object)friendship.getId(), (Object)this.getNodeState(this.testTeam.david).getSingleRelationship((RelationshipType)KNOWS, Direction.OUTGOING).getId());
        List friendships = (List)IteratorUtil.addToCollection((Iterable)this.friendshipRepository.findAll(), new ArrayList());
        Assert.assertEquals((long)2L, (long)friendships.size());
        Assert.assertThat((Object)friendships, (Matcher)Matchers.hasItems((Object[])new Friendship[]{this.testTeam.friendShip, friendship}));
    }

    @Test
    @Transactional
    public void testCreateDuplicateRelationshipBetweenNodes() throws Exception {
        this.neo4jOperations.createRelationshipBetween((Object)this.testTeam.michael, (Object)this.testTeam.david, Friendship.class, "knows", true);
        Assert.assertEquals((long)2L, (long)IteratorUtil.asCollection((Iterable)this.getNodeState(this.testTeam.michael).getRelationships((RelationshipType)KNOWS, Direction.OUTGOING)).size());
    }

    @Test
    @Transactional
    public void testCreateRelationshipBetween() throws Exception {
        Node davidNode = this.getNodeState(this.testTeam.david);
        Relationship friendship = this.neo4jOperations.createRelationshipBetween(davidNode, this.getNodeState(this.testTeam.emil), "knows", MapUtil.map((Object[])new Object[]{"years", 10}));
        Assert.assertEquals((long)friendship.getId(), (long)davidNode.getSingleRelationship((RelationshipType)KNOWS, Direction.OUTGOING).getId());
        Assert.assertEquals((Object)10, (Object)friendship.getProperty("years"));
    }

    @Test
    @Transactional
    public void testConvertSingle() throws Exception {
        Person p = (Person)this.neo4jOperations.convert((Object)this.neo4jOperations.getPersistentState((Object)this.testTeam.michael), Person.class);
        Assert.assertEquals((Object)this.testTeam.michael.getName(), (Object)p.getName());
    }

    @Test
    @Transactional
    public void testConvert() throws Exception {
        Result groups = this.neo4jOperations.convert(Arrays.asList(this.getNodeState(this.testTeam.sdg))).to(Group.class);
        Assert.assertEquals((Object)this.testTeam.sdg.getName(), (Object)((Group)groups.iterator().next()).getName());
    }

    @Test
    @Transactional
    public void testQueryEngineForCypher() throws Exception {
        CypherQueryEngine engine = this.neo4jOperations.queryEngineFor();
        Person result = (Person)engine.query("start n=node({self}) return n", MapUtil.map((Object[])new Object[]{"self", this.testTeam.michael.getId()})).to(Person.class).single();
        Assert.assertEquals((Object)this.testTeam.michael.getId(), (Object)result.getId());
    }

    @Test
    @Transactional
    public void testTraverse() throws Exception {
        TraversalDescription traversalDescription = this.neo4jOperations.traversalDescription().relationships((RelationshipType)DynamicRelationshipType.withName((String)"knows"), Direction.OUTGOING).evaluator(Evaluators.excludeStartPosition());
        Person knows = (Person)this.neo4jOperations.traverse((Object)this.testTeam.michael, traversalDescription).to(Person.class).single();
        Assert.assertEquals((Object)this.testTeam.david.getName(), (Object)knows.getName());
    }

    @Test
    @Transactional
    public void testLookup() throws Exception {
        Person found = (Person)this.neo4jOperations.lookup(Person.class, "name", (Object)"name:Michael").to(Person.class).single();
        Assert.assertEquals((Object)this.testTeam.michael.getId(), (Object)found.getId());
    }

    @Test
    @Transactional
    public void testLookupExact() throws Exception {
        Person found = (Person)this.neo4jOperations.lookup(Person.class, "name", (Object)"Michael").to(Person.class).single();
        Assert.assertEquals((Object)this.testTeam.michael.getId(), (Object)found.getId());
    }

    @Test(expected=InvalidDataAccessApiUsageException.class)
    @Transactional
    public void testLookupExactLabelIndex() throws Exception {
        Person found = (Person)this.neo4jOperations.lookup(Person.class, "alias", (Object)"michaelAlias").to(Person.class).single();
        Assert.assertEquals((Object)this.testTeam.michael.getId(), (Object)found.getId());
    }

    @Test
    @Transactional
    public void testFindAllSchemaIndex() throws Exception {
        Person found = (Person)this.neo4jOperations.findByIndexedValue(Person.class, "alias", (Object)"michaelAlias").single();
        Assert.assertEquals((Object)this.testTeam.michael.getId(), (Object)found.getId());
    }

    static abstract class ManagedTestEntity
    implements ManagedEntity {
        ManagedTestEntity() {
        }
    }
}

