/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.model.FriendshipRepository;
import org.springframework.data.neo4j.model.GroupRepository;
import org.springframework.data.neo4j.model.PersonRepository;
import org.springframework.data.neo4j.repository.TestTeam;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.transaction.BeforeTransaction;

public class EntityTestBase {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected Neo4jTemplate template;
    @Autowired
    protected ConversionService conversionService;
    @Autowired
    protected GraphDatabaseService graphDatabaseService;
    @Autowired
    protected PersonRepository personRepository;
    @Autowired
    protected GroupRepository groupRepository;
    @Autowired
    protected FriendshipRepository friendshipRepository;
    protected TestTeam testTeam = new TestTeam();

    public void createTeam() throws Exception {
        this.testTeam.createSDGTeam(this.personRepository, this.groupRepository, this.friendshipRepository);
    }

    protected Node getNodeState(Object entity) {
        return (Node)this.template.getPersistentState(entity);
    }

    protected Long getNodeId(Object entity) {
        Node node = (Node)this.template.getPersistentState(entity);
        return node == null ? null : Long.valueOf(node.getId());
    }

    protected Long getRelationshipId(Object entity) {
        Relationship rel = (Relationship)this.template.getPersistentState(entity);
        return rel == null ? null : Long.valueOf(rel.getId());
    }

    protected boolean hasPersistentState(Object entity) {
        return this.template.getPersistentState(entity) != null;
    }

    protected Relationship getRelationshipState(Object entity) {
        return (Relationship)this.template.getPersistentState(entity);
    }

    public <T> T persist(T entity) {
        return (T)this.template.save(entity);
    }

    protected <T> Set<T> set(T ... values) {
        return new HashSet<T>(Arrays.asList(values));
    }

    protected void manualCleanDb() {
        try (Transaction tx = this.graphDatabaseService.beginTx();){
            this.cleanDb();
            tx.success();
        }
    }

    @BeforeTransaction
    public void cleanDb() {
        Neo4jHelper.cleanDb(this.template);
    }
}

