/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.support.DelegatingGraphDatabase;
import org.springframework.data.neo4j.support.GraphDatabaseFactoryBean;

public class GraphDatabaseFactoryTests {
    @Test
    public void shouldCreateLocalDatabaseFromContext() throws Exception {
        try (ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("GraphDatabaseFactory-context.xml");){
            GraphDatabase graphDatabase = (GraphDatabase)ctx.getBean("graphDatabase", GraphDatabase.class);
            Assert.assertThat((Object)graphDatabase, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
            Assert.assertThat((Object)graphDatabase, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(DelegatingGraphDatabase.class)));
        }
    }

    @Test
    public void shouldCreateLocalDatabase() throws Exception {
        GraphDatabaseFactoryBean factory = new GraphDatabaseFactoryBean();
        try {
            factory.setStoreLocation("target/test-db");
            GraphDatabase graphDatabase = factory.getObject();
            Assert.assertThat((Object)graphDatabase, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
            Assert.assertThat((Object)graphDatabase, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(DelegatingGraphDatabase.class)));
        }
        finally {
            factory.shutdown();
        }
    }
}

