/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.conversion;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.data.neo4j.repository.MemberData;
import org.springframework.data.neo4j.repository.MemberDataPOJO;
import org.springframework.data.neo4j.support.conversion.AConfusedPOJO;
import org.springframework.data.neo4j.support.conversion.ADeprecatedMapResultInterface;
import org.springframework.data.neo4j.support.conversion.APlainInterface;
import org.springframework.data.neo4j.support.conversion.EntityResultConverter;

public class EntityResultConverterTest {
    private EntityResultConverter converter;

    @Before
    public void setup() {
        this.converter = new EntityResultConverter(null);
    }

    @Test
    public void testInterfaceWithDeprecatedMapResultAnnotationIsIdentifiedAsNeedingInterfaceBasedMapping() {
        boolean result = this.converter.isInterfaceBasedMappingRequest(ADeprecatedMapResultInterface.class);
        Assert.assertTrue((String)"Expect interfaces with deprecated @MapResult annotation to be identified correctly", (boolean)result);
    }

    @Test
    public void testInterfaceWithQueryAnnotationIsIdentifiedAsNeedingInterfaceBasedMapping() {
        boolean result = this.converter.isInterfaceBasedMappingRequest(MemberData.class);
        Assert.assertTrue((String)"Expect interfaces with new @QueryResult annotation to be identified correctly", (boolean)result);
    }

    @Test
    public void testInterfaceWithNoAnnotationIsNotIdentifiedAsNeedingInterfaceBasedMapping() {
        boolean result = this.converter.isInterfaceBasedMappingRequest(APlainInterface.class);
        Assert.assertFalse((String)"Expect interfaces with no @QueryResult or @MapResult annotation to be identified correctly", (boolean)result);
    }

    @Test
    public void testPojoWithQueryAnnotationIsNotIdentifiedAsNeedingInterfaceBasedMapping() {
        boolean testResult = this.converter.isInterfaceBasedMappingRequest(MemberDataPOJO.class);
        Assert.assertFalse((String)"POJO annotated class with @QueryResult should not be identified as requiring interface based mapping", (boolean)testResult);
    }

    @Test
    public void testPojoWithQueryAnnotationIsIdentifiedAsNeedingPOJOBasedMapping() {
        boolean testResult = this.converter.isPojoBasedMappingReqest(MemberDataPOJO.class);
        Assert.assertTrue((String)"POJO annotated class with @QueryResult should be identified as requiring POJO based mapping", (boolean)testResult);
    }

    @Test
    public void testPojoWithDeprecatedIFAnnotationIsIdentifiedCorrectly() {
        boolean isPojoResult = this.converter.isPojoBasedMappingReqest(AConfusedPOJO.class);
        boolean isInterfaceResult = this.converter.isInterfaceBasedMappingRequest(AConfusedPOJO.class);
        Assert.assertFalse((String)"POJO using deprecated @MapResult interface annotation should not be identified as requiring POJO based mapping", (boolean)isPojoResult);
        Assert.assertFalse((String)"POJO using deprecated @MapResult annotation should not be identified as requiring Interface based mapping", (boolean)isInterfaceResult);
    }
}

