/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.Traversal;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.neo4j.config.JtaTransactionManagerFactoryBean;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.support.DelegatingGraphDatabase;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class Neo4jTemplateApiTests {
    private static final DynamicRelationshipType KNOWS = DynamicRelationshipType.withName((String)"knows");
    private static final DynamicRelationshipType HAS = DynamicRelationshipType.withName((String)"has");
    protected Neo4jTemplate template;
    protected GraphDatabase graphDatabase;
    protected Node node0;
    protected Relationship relationship1;
    protected Node node1;
    protected PlatformTransactionManager transactionManager;
    protected GraphDatabaseService graphDatabaseService;
    private Transaction transaction;

    @Before
    public void setUp() throws Exception {
        this.graphDatabaseService = this.createGraphDatabaseService();
        this.graphDatabase = this.createGraphDatabase();
        this.transactionManager = this.createTransactionManager();
        this.template = new Neo4jTemplate(this.graphDatabase, this.transactionManager);
        this.createData();
        this.transaction = this.graphDatabase.beginTx();
    }

    protected GraphDatabaseService createGraphDatabaseService() throws IOException {
        return new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    protected GraphDatabase createGraphDatabase() throws Exception {
        return new DelegatingGraphDatabase(this.graphDatabaseService);
    }

    protected PlatformTransactionManager createTransactionManager() {
        return new JtaTransactionManagerFactoryBean(this.graphDatabaseService).getObject();
    }

    private void createData() {
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                Neo4jTemplateApiTests.this.node0 = Neo4jTemplateApiTests.this.graphDatabase.createNode(MapUtil.map((Object[])new Object[]{"name", "node0"}), Arrays.asList("Node"));
                Neo4jTemplateApiTests.this.graphDatabase.createIndex(Node.class, "node", IndexType.SIMPLE).add((PropertyContainer)Neo4jTemplateApiTests.this.node0, "name", (Object)"node0");
                Neo4jTemplateApiTests.this.node1 = Neo4jTemplateApiTests.this.graphDatabase.createNode(MapUtil.map((Object[])new Object[]{"name", "node1"}), Arrays.asList("Node"));
                Neo4jTemplateApiTests.this.relationship1 = Neo4jTemplateApiTests.this.node0.createRelationshipTo(Neo4jTemplateApiTests.this.node1, (RelationshipType)KNOWS);
                Neo4jTemplateApiTests.this.relationship1.setProperty("name", (Object)"rel1");
                Neo4jTemplateApiTests.this.graphDatabase.createIndex(Relationship.class, "relationship", IndexType.SIMPLE).add((PropertyContainer)Neo4jTemplateApiTests.this.relationship1, "name", (Object)"rel1");
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        if (this.transaction != null) {
            try {
                this.transaction.success();
                this.transaction.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.graphDatabaseService != null) {
            this.graphDatabaseService.shutdown();
        } else if (this.graphDatabase != null) {
            this.graphDatabase.shutdown();
        }
    }

    @Test(expected=DataAccessException.class)
    public void shouldConvertTemplateNotFoundExceptionToDataAccessException() {
        this.template.getNode(Long.MAX_VALUE);
    }

    @Test
    public void testGetNode() throws Exception {
        Node lookedUpNode = this.template.getNode(this.node0.getId());
        Assert.assertEquals((Object)this.node0, (Object)lookedUpNode);
    }

    @Test
    public void testGetRelationship() throws Exception {
        Relationship lookedUpRelationship = this.template.getRelationship(this.relationship1.getId());
        Assert.assertThat((Object)lookedUpRelationship, (Matcher)CoreMatchers.is((Object)this.relationship1));
    }

    @Test
    public void testIndexRelationship() throws Exception {
        Index index = this.graphDatabase.getIndex("relationship");
        Relationship lookedUpRelationship = (Relationship)index.get("name", (Object)"rel1").getSingle();
        Assert.assertThat((String)"same relationship from index", (Object)lookedUpRelationship, (Matcher)CoreMatchers.is((Object)this.relationship1));
    }

    @Test
    public void testIndexNode() throws Exception {
        this.template.index("node", (PropertyContainer)this.node1, "name", (Object)"node1");
        this.transaction.success();
        this.transaction.close();
        this.transaction = this.graphDatabase.beginTx();
        Index index = this.graphDatabase.getIndex("node");
        Node lookedUpNode = (Node)index.get("name", (Object)"node1").getSingle();
        Assert.assertThat((String)"same node from index", (Object)lookedUpNode, (Matcher)CoreMatchers.is((Object)this.node1));
    }

    @Test
    public void testQueryNodes() throws Exception {
        this.assertSingleResult((Object)"node0", (Iterable)this.template.lookup("node", (Object)new TermQuery(new Term("name", "node0"))).to(String.class, (ResultConverter)new PropertyContainerNameConverter()));
    }

    @Test
    public void testRetrieveNodes() throws Exception {
        this.assertSingleResult((Object)"node0", (Iterable)this.template.lookup("node", "name", (Object)"node0").to(String.class, (ResultConverter)new PropertyContainerNameConverter()));
    }

    @Test
    public void testQueryRelationships() throws Exception {
        this.assertSingleResult((Object)"rel1", (Iterable)this.template.lookup("relationship", (Object)new TermQuery(new Term("name", "rel1"))).to(String.class, (ResultConverter)new PropertyContainerNameConverter()));
    }

    @Test
    public void testRetrieveRelationships() throws Exception {
        this.assertSingleResult((Object)"rel1", (Iterable)this.template.lookup("relationship", "name", (Object)"rel1").to(String.class, (ResultConverter)new PropertyContainerNameConverter()));
    }

    @Test
    public void testTraverse() throws Exception {
        TraversalDescription description = Traversal.description().relationships((RelationshipType)KNOWS).evaluator(Evaluators.toDepth((int)1)).evaluator(Evaluators.excludeStartPosition());
        this.assertSingleResult((Object)"node1", (Iterable)this.template.traverse(this.node0, description).to(String.class, (ResultConverter)new PathNodeNameMapper()));
    }

    @Test
    public void shouldFindNextNodeViaCypher() throws Exception {
        this.assertSingleResult((Object)this.node1, (Iterable)this.template.query("start n=node(" + this.node0.getId() + ") match (n)-->(m) return m", null).to(Node.class));
    }

    @Test
    public void shouldGetDirectRelationship() throws Exception {
        this.assertSingleResult((Object)"rel1", (Iterable)this.template.convert(this.node0.getRelationships()).to(String.class, (ResultConverter)new RelationshipNameConverter()));
    }

    @Test
    public void shouldGetDirectRelationshipForType() throws Exception {
        this.assertSingleResult((Object)"rel1", (Iterable)this.template.convert(this.node0.getRelationships(new RelationshipType[]{KNOWS})).to(String.class, (ResultConverter)new RelationshipNameConverter()));
    }

    @Test
    public void shouldGetDirectRelationshipForTypeAndDirection() throws Exception {
        this.assertSingleResult((Object)"rel1", (Iterable)this.template.convert(this.node0.getRelationships((RelationshipType)KNOWS, Direction.OUTGOING)).to(String.class, (ResultConverter)new RelationshipNameConverter()));
    }

    private <T> void assertSingleResult(T expected, Iterable<T> iterable) {
        Iterator<T> result = iterable.iterator();
        Assert.assertEquals(expected, result.next());
        Assert.assertEquals((Object)false, (Object)result.hasNext());
    }

    @Test
    public void shouldCreateRelationshipWithProperty() throws Exception {
        Relationship relationship = this.template.createRelationshipBetween(this.node0, this.node1, "has", MapUtil.map((Object[])new Object[]{"name", "rel2"}));
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((Object)this.node0, (Object)relationship.getStartNode());
        Assert.assertEquals((Object)this.node1, (Object)relationship.getEndNode());
        Assert.assertEquals((Object)HAS.name(), (Object)relationship.getType().name());
        Assert.assertEquals((Object)"rel2", (Object)relationship.getProperty("name", (Object)"not set"));
    }

    private static class PropertyContainerNameConverter
    extends ResultConverter.ResultConverterAdapter<PropertyContainer, String> {
        private PropertyContainerNameConverter() {
        }

        public String convert(PropertyContainer value, Class<String> type) {
            return (String)value.getProperty("name");
        }
    }

    private static class RelationshipNameConverter
    extends ResultConverter.ResultConverterAdapter<Relationship, String> {
        private RelationshipNameConverter() {
        }

        public String convert(Relationship value, Class<String> type) {
            return (String)value.getProperty("name");
        }
    }

    private static class PathNodeNameMapper
    extends ResultConverter.ResultConverterAdapter<Path, String> {
        private PathNodeNameMapper() {
        }

        public String convert(Path path, Class<String> type) {
            return (String)path.endNode().getProperty("name", (Object)"not set");
        }
    }
}

