/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import org.junit.After;
import org.junit.Before;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.config.JtaTransactionManagerFactoryBean;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.fieldaccess.Neo4jConversionServiceFactoryBean;
import org.springframework.data.neo4j.support.DelegatingGraphDatabase;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class NeoApiTests {
    protected GraphDatabase graph;
    protected Neo4jTemplate template;
    protected PlatformTransactionManager transactionManager;
    private GraphDatabaseService graphDatabaseService;
    protected ConversionService conversionService;

    @Before
    public void setUp() throws Exception {
        this.conversionService = this.createConversionService();
        this.graph = this.createGraphDatabase();
        this.transactionManager = this.createTransactionManager();
        this.template = new Neo4jTemplate(this.graph, this.transactionManager);
    }

    private ConversionService createConversionService() throws Exception {
        return new Neo4jConversionServiceFactoryBean().getObject();
    }

    protected PlatformTransactionManager createTransactionManager() {
        return new JtaTransactionManagerFactoryBean(this.graphDatabaseService).getObject();
    }

    protected GraphDatabase createGraphDatabase() throws Exception {
        this.graphDatabaseService = new TestGraphDatabaseFactory().newImpermanentDatabase();
        return new DelegatingGraphDatabase(this.graphDatabaseService);
    }

    @After
    public void tearDown() {
        if (this.graphDatabaseService != null) {
            this.graphDatabaseService.shutdown();
        }
    }
}

