/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.Traversal;
import org.springframework.data.neo4j.conversion.Handler;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.template.GraphCallback;
import org.springframework.data.neo4j.template.NeoApiTests;

public class NeoTraversalTests
extends NeoApiTests {
    @Test
    public void testSimpleTraverse() {
        final Node family = (Node)this.template.exec((GraphCallback)new GraphCallback<Node>(){

            public Node doWithGraph(GraphDatabase graph) throws Exception {
                return NeoTraversalTests.this.createFamily();
            }
        });
        this.template.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                final HashSet resultSet = new HashSet();
                TraversalDescription description = Traversal.description().relationships((RelationshipType)Type.HAS).evaluator(Evaluators.excludeStartPosition()).evaluator(Evaluators.toDepth((int)1));
                Result result = NeoTraversalTests.this.template.traverse(family, description);
                result.handle((Handler)new Handler<Path>(){

                    public void handle(Path value) {
                        String name = (String)value.endNode().getProperty("name", (Object)"");
                        resultSet.add(name);
                    }
                });
                Assert.assertEquals((String)"all members", new HashSet<String>(Arrays.asList("grandpa", "grandma", "daughter", "son", "man", "wife")), resultSet);
            }
        });
    }

    private Node createFamily() {
        Node family = this.template.createNode(MapUtil.map((Object[])new Object[]{"name", "family"}));
        Node man = this.template.createNode(MapUtil.map((Object[])new Object[]{"name", "wife"}));
        Node wife = this.template.createNode(MapUtil.map((Object[])new Object[]{"name", "man"}));
        family.createRelationshipTo(man, (RelationshipType)Type.HAS);
        family.createRelationshipTo(wife, (RelationshipType)Type.HAS);
        Node daughter = this.template.createNode(MapUtil.map((Object[])new Object[]{"name", "daughter"}));
        family.createRelationshipTo(daughter, (RelationshipType)Type.HAS);
        Node son = this.template.createNode(MapUtil.map((Object[])new Object[]{"name", "son"}));
        family.createRelationshipTo(son, (RelationshipType)Type.HAS);
        man.createRelationshipTo(son, (RelationshipType)Type.CHILD);
        wife.createRelationshipTo(son, (RelationshipType)Type.CHILD);
        man.createRelationshipTo(daughter, (RelationshipType)Type.CHILD);
        wife.createRelationshipTo(daughter, (RelationshipType)Type.CHILD);
        Node grandma = this.template.createNode(MapUtil.map((Object[])new Object[]{"name", "grandma"}));
        Node grandpa = this.template.createNode(MapUtil.map((Object[])new Object[]{"name", "grandpa"}));
        family.createRelationshipTo(grandma, (RelationshipType)Type.HAS);
        family.createRelationshipTo(grandpa, (RelationshipType)Type.HAS);
        grandma.createRelationshipTo(man, (RelationshipType)Type.CHILD);
        grandpa.createRelationshipTo(man, (RelationshipType)Type.CHILD);
        grandma.createRelationshipTo(son, (RelationshipType)Type.GRANDSON);
        grandpa.createRelationshipTo(son, (RelationshipType)Type.GRANDSON);
        grandma.createRelationshipTo(daughter, (RelationshipType)Type.GRANDDAUGHTER);
        grandpa.createRelationshipTo(daughter, (RelationshipType)Type.GRANDDAUGHTER);
        return family;
    }

    static enum Type implements RelationshipType
    {
        MARRIED,
        CHILD,
        GRANDSON,
        GRANDDAUGHTER,
        WIFE,
        HUSBAND,
        HAS;

    }
}

