/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.test.snippets;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.MapUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.test.DocumentingTestBase;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:DocumentingTests-context.xml"})
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
public class SnippetNeo4jTemplateMethodsTests
extends DocumentingTestBase {
    @Autowired
    private Neo4jTemplate neo;
    private static final RelationshipType WORKS_WITH = DynamicRelationshipType.withName((String)"WORKS_WITH");

    @Test
    @Transactional
    public void documentTemplateMethods() {
        this.title = "Basic operations";
        this.paragraphs = new String[]{"For direct retrieval of nodes and relationships, the <code>getReferenceNode()</code>,\n           <code>getNode()</code> and <code>getRelationship()</code> methods can be used.", "There are methods (<code>createNode()</code> and <code>createRelationship()</code>) for creating nodes and\n           relationships that automatically set provided properties."};
        this.snippetTitle = "Neo4j template";
        this.snippet = "template";
        Node mark = this.neo.createNode(MapUtil.map((Object[])new Object[]{"name", "Mark"}));
        Node thomas = this.neo.createNode(MapUtil.map((Object[])new Object[]{"name", "Thomas"}));
        this.neo.createRelationshipBetween(mark, thomas, "WORKS_WITH", MapUtil.map((Object[])new Object[]{"project", "spring-data"}));
        this.neo.index("devs", (PropertyContainer)thomas, "name", (Object)"Thomas");
        Assert.assertEquals((Object)"Mark", (Object)this.neo.query("start p=node({person}) match p<-[:WORKS_WITH]-other return other.name", MapUtil.map((Object[])new Object[]{"person", Arrays.asList(thomas.getId())})).to(String.class).single());
        Assert.assertEquals((Object)thomas, (Object)this.neo.lookup("devs", "name", (Object)"Thomas").to(Node.class).single());
        Assert.assertEquals((Object)"Thomas", (Object)this.neo.lookup("devs", "name", (Object)"Thomas").to(String.class, (ResultConverter)new ResultConverter.ResultConverterAdapter<PropertyContainer, String>(){

            public String convert(PropertyContainer element, Class<String> type) {
                return (String)element.getProperty("name");
            }
        }).single());
    }
}

