/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.neo4j.annotation.IdentifiableEntity;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class RelationshipDelegates {
    public static Set<String> getRelationshipNames(Neo4jTemplate template, IdentifiableEntity entity) {
        HashSet<String> relationshipNames = new HashSet<String>();
        for (Relationship relationship : RelationshipDelegates.getRelationships(template, entity)) {
            relationshipNames.add(relationship.getType().name());
        }
        return relationshipNames;
    }

    public static Integer getNumberOfRelationships(Neo4jTemplate template, IdentifiableEntity entity) {
        return IteratorUtil.count(RelationshipDelegates.getRelationships(template, entity));
    }

    private static Iterable<Relationship> getRelationships(Neo4jTemplate template, IdentifiableEntity entity) {
        return template.getNode(entity.getId().longValue()).getRelationships();
    }
}

