/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation.graphproperty;

import java.util.Calendar;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.annotation.graphproperty.Artist;
import org.springframework.data.neo4j.annotation.graphproperty.ArtistRepository;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:graphproperty-annotation-test-context.xml"})
@Transactional
public class GraphPropertyAnnotationTests {
    @Autowired
    Neo4jTemplate neo4jTemplate;
    @Autowired
    ArtistRepository artistRepository;

    @Test
    public void shouldSaveANodeWithRenamedPropertyNames() throws Exception {
        Calendar born = Calendar.getInstance();
        Calendar died = Calendar.getInstance();
        born.set(1853, 2, 30, 0, 0, 0);
        died.set(1890, 6, 29, 0, 0, 0);
        Artist vanGogh = new Artist("Vincent", "Willem", "Van Gogh", born.getTime(), died.getTime());
        Artist vanGoghSavedNode = (Artist)this.artistRepository.save(vanGogh);
        Artist vanGoghRetrievedNode = (Artist)this.artistRepository.findOne(vanGoghSavedNode.getId());
        Assert.assertEquals((Object)"Vincent", (Object)vanGoghRetrievedNode.getFirstName());
        Assert.assertEquals((Object)"Willem", (Object)vanGoghRetrievedNode.getSecondName());
        Assert.assertEquals((Object)"Van Gogh", (Object)vanGoghRetrievedNode.getLastName());
        Assert.assertEquals((Object)born.getTime(), (Object)vanGoghRetrievedNode.getBorn());
        Assert.assertEquals((Object)died.getTime(), (Object)vanGoghRetrievedNode.getDied());
        Node node = this.neo4jTemplate.getNode(vanGoghSavedNode.getId().longValue());
        Assert.assertEquals((Object)"Vincent", (Object)node.getProperty("first_name"));
        Assert.assertEquals((Object)"Willem", (Object)node.getProperty("second_name"));
        Assert.assertEquals((Object)"Van Gogh", (Object)node.getProperty("last_name"));
        Assert.assertEquals((long)born.getTimeInMillis(), (long)Long.parseLong((String)node.getProperty("born")));
        Assert.assertEquals((long)died.getTimeInMillis(), (long)Long.parseLong((String)node.getProperty("died")));
    }
}

