/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation.relatedto;

import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Direction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.annotation.EndNode;
import org.springframework.data.neo4j.annotation.Fetch;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.annotation.RelatedToVia;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.annotation.StartNode;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:related-to-test-context.xml"})
@Transactional
public class BiDirectionalRelatedToViaMappingTests {
    @Autowired
    Neo4jTemplate template;

    @Test
    public void testLoadBidirectionalRelationship() throws Exception {
        TestEntityBiDirectional one = (TestEntityBiDirectional)this.template.save((Object)new TestEntityBiDirectional());
        TestEntityBiDirectional kid = (TestEntityBiDirectional)this.template.save((Object)new TestEntityBiDirectional());
        TestEntityBiDirectional kid2 = (TestEntityBiDirectional)this.template.save((Object)new TestEntityBiDirectional());
        TestRelationshipBiDirectional rel1 = (TestRelationshipBiDirectional)this.template.save((Object)new TestRelationshipBiDirectional(one, kid));
        this.template.save((Object)new TestRelationshipBiDirectional(one, kid2));
        TestEntityBiDirectional anotherOne = (TestEntityBiDirectional)this.template.findOne(kid.id.longValue(), TestEntityBiDirectional.class);
        Assert.assertSame((Object)rel1.id, (Object)anotherOne.parent.id);
        this.template.fetch((Object)anotherOne.parent);
        Assert.assertSame((Object)anotherOne.id, (Object)anotherOne.parent.kid.id);
        Assert.assertSame((Object)one.id, (Object)anotherOne.parent.parent.id);
        Assert.assertSame((Object)anotherOne.directParent.id, (Object)anotherOne.parent.parent.id);
    }

    @RelationshipEntity(type="test")
    static class TestRelationshipBiDirectional {
        @GraphId
        Long id;
        @Fetch
        @StartNode
        TestEntityBiDirectional parent;
        @Fetch
        @EndNode
        TestEntityBiDirectional kid;

        TestRelationshipBiDirectional() {
        }

        public TestRelationshipBiDirectional(TestEntityBiDirectional parent, TestEntityBiDirectional kid) {
            this.parent = parent;
            this.kid = kid;
        }
    }

    @NodeEntity
    static class TestEntityBiDirectional {
        @GraphId
        Long id;
        @RelatedTo(type="test", direction=Direction.INCOMING)
        TestEntityBiDirectional directParent;
        @RelatedToVia(type="test")
        Set<TestRelationshipBiDirectional> kids;
        @RelatedToVia(type="test", direction=Direction.INCOMING)
        TestRelationshipBiDirectional parent;

        TestEntityBiDirectional() {
        }
    }
}

