/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation.relatedto;

import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Direction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.annotation.EndNode;
import org.springframework.data.neo4j.annotation.Fetch;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.annotation.RelatedToVia;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.annotation.StartNode;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:related-to-test-context.xml"})
@DirtiesContext
@Transactional
public class BiDirectionalRelatedToViaWithSingleFetchMappingTests {
    @Autowired
    Neo4jTemplate template;

    @Test
    public void testLoadBidirectionalRelationship() throws Exception {
        TestEntitySingle one = (TestEntitySingle)this.template.save((Object)new TestEntitySingle());
        TestEntitySingle kid = (TestEntitySingle)this.template.save((Object)new TestEntitySingle());
        TestEntitySingle kid2 = (TestEntitySingle)this.template.save((Object)new TestEntitySingle());
        TestRelationshipSingle rel1 = (TestRelationshipSingle)this.template.save((Object)new TestRelationshipSingle(one, kid));
        this.template.save((Object)new TestRelationshipSingle(one, kid2));
        TestEntitySingle anotherOne = (TestEntitySingle)this.template.findOne(kid.id.longValue(), TestEntitySingle.class);
        Assert.assertSame((Object)rel1.id, (Object)anotherOne.parent.id);
        Assert.assertSame((Object)anotherOne, (Object)anotherOne.parent.kid);
        Assert.assertSame((Object)one.id, (Object)anotherOne.parent.parent.id);
        Assert.assertSame((Object)anotherOne.directParent, (Object)anotherOne.parent.parent);
    }

    @RelationshipEntity(type="test")
    static class TestRelationshipSingle {
        @GraphId
        Long id;
        @Fetch
        @StartNode
        TestEntitySingle parent;
        @Fetch
        @EndNode
        TestEntitySingle kid;

        TestRelationshipSingle() {
        }

        public TestRelationshipSingle(TestEntitySingle parent, TestEntitySingle kid) {
            this.parent = parent;
            this.kid = kid;
        }
    }

    @NodeEntity
    static class TestEntitySingle {
        @GraphId
        Long id;
        @RelatedTo(type="test", direction=Direction.INCOMING)
        TestEntitySingle directParent;
        @RelatedToVia(type="test")
        Set<TestRelationshipSingle> kids;
        @Fetch
        @RelatedToVia(type="test", direction=Direction.INCOMING)
        TestRelationshipSingle parent;

        TestEntitySingle() {
        }
    }
}

