/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation.relatedto;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.data.neo4j.annotation.IdentifiableEntity;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.annotation.relatedto.Quadrilateral;
import org.springframework.data.neo4j.annotation.relatedto.Rectangle;
import org.springframework.data.neo4j.annotation.relatedto.Square;

@NodeEntity
public class Mondrian
extends IdentifiableEntity {
    public static short RED = 1;
    public static short YELLOW = (short)2;
    public static short BLUE = (short)3;
    private String title;
    @RelatedTo(type="includes", enforceTargetType=true)
    private Square square;
    @RelatedTo(type="includes", enforceTargetType=true)
    private Set<Rectangle> rectangles = new HashSet<Rectangle>();
    @RelatedTo(type="includes", enforceTargetType=true)
    private Iterable<Quadrilateral> quadrilaterals;

    public Mondrian() {
    }

    public Mondrian(String title) {
        this.title = title;
    }

    public void includes(Square square) {
        this.square = square;
    }

    public void includes(Rectangle ... rectangles) {
        this.rectangles.addAll(Arrays.asList(rectangles));
    }

    public Square getSquare() {
        return this.square;
    }

    public Set<Rectangle> getRectangles() {
        return this.rectangles;
    }

    public Iterable<Quadrilateral> getQuadrilaterals() {
        return this.quadrilaterals;
    }
}

