/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.lifecycle.BeforeSaveEvent;

public class AuditingIntegrationTests {
    @Test
    public void enablesAuditingAndSetsPropertiesAccordingly() throws InterruptedException {
        this.runTest(new ClassPathXmlApplicationContext("auditing.xml", this.getClass())).close();
    }

    @Test
    public void enablesAuditingWithBeanConfigAndSetsPropertiesAccordingly() throws InterruptedException {
        this.runTest(new ClassPathXmlApplicationContext("auditing-bean.xml", this.getClass())).close();
    }

    private <T extends ApplicationEventPublisher> T runTest(T context) throws InterruptedException {
        Entity entity = new Entity();
        BeforeSaveEvent event = new BeforeSaveEvent((Object)this, (Object)entity);
        context.publishEvent((ApplicationEvent)event);
        Assert.assertThat((Object)entity.created, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)entity.modified, (Matcher)CoreMatchers.is((Object)entity.created));
        Thread.sleep(10L);
        entity.id = 1L;
        event = new BeforeSaveEvent((Object)this, (Object)entity);
        context.publishEvent((ApplicationEvent)event);
        Assert.assertThat((Object)entity.created, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)entity.modified, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)entity.created)));
        return context;
    }

    @NodeEntity
    public static class Entity {
        @GraphId
        Long id;
        @CreatedDate
        DateTime created;
        @LastModifiedDate
        DateTime modified;
    }
}

