/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.data.neo4j.config.spring.BasicJavaConfig;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.repositories.PersonRepository;

public class BasicJavaConfigTest {
    AnnotationConfigApplicationContext appCtx;

    @After
    public void tearDown() {
        if (this.appCtx != null) {
            this.appCtx.stop();
        }
    }

    @Test
    public void verifyAppCtxStartsCorrectlyWithJavaConfig() {
        this.startJavaBasedAppCtx();
    }

    private void startJavaBasedAppCtx() {
        this.appCtx = new AnnotationConfigApplicationContext();
        this.appCtx.register(new Class[]{BasicJavaConfig.class});
        this.appCtx.registerShutdownHook();
        this.appCtx.refresh();
    }

    @Test
    public void testBasicRepositoryFunctionality() {
        this.startJavaBasedAppCtx();
        GraphDatabaseService graphDatabaseService = (GraphDatabaseService)this.appCtx.getBean(GraphDatabaseService.class);
        PersonRepository personRepository = (PersonRepository)this.appCtx.getBean(PersonRepository.class);
        try (Transaction tx = graphDatabaseService.beginTx();){
            Person person = new Person("Howdy", 50);
            personRepository.save(person);
            Assert.assertNotNull((Object)person.getId());
            tx.success();
        }
    }
}

