/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.conversion;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.neo4j.conversion.ContainerConverter;

public class ContainerConverterTest {
    @Test
    public void testSliceFirst() throws Exception {
        Slice slice = ContainerConverter.slice(Arrays.asList(1, 2, 3), (Pageable)new PageRequest(0, 1));
        Assert.assertThat((Object)slice.getContent(), (Matcher)Matchers.hasItem((Object)1));
        Assert.assertThat((Object)slice.getSize(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)slice.hasNext(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testSliceLast() throws Exception {
        Slice slice = ContainerConverter.slice(Arrays.asList(1, 2, 3), (Pageable)new PageRequest(2, 1));
        Assert.assertThat((Object)slice.getContent(), (Matcher)Matchers.hasItem((Object)3));
        Assert.assertThat((Object)slice.getSize(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)slice.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testSliceAll() throws Exception {
        Slice slice = ContainerConverter.slice(Arrays.asList(1, 2, 3), (Pageable)new PageRequest(0, 3));
        Assert.assertThat((Object)slice.getContent(), (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat((Object)slice.getSize(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)slice.hasNext(), (Matcher)Is.is((Object)false));
    }
}

