/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.conversion;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.GraphProperty;
import org.springframework.data.neo4j.annotation.Indexed;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
public class EnumConverterTests {
    @Autowired
    Neo4jTemplate template;

    @Test
    @Transactional
    public void testConvertEnumsAccordingToAnnotation() throws Exception {
        Word word = (Word)this.template.save((Object)new Word(Letter.C, Vowel.A, Consonant.B));
        Assert.assertEquals((Object)((Object)Letter.C), (Object)((Object)word.letter));
        Assert.assertEquals((Object)((Object)Vowel.A), (Object)((Object)word.vowel));
        Assert.assertEquals((Object)((Object)Consonant.B), (Object)((Object)word.consonant));
        PropertyContainer node = this.template.getPersistentState((Object)word);
        Assert.assertEquals((Object)Letter.C.name(), (Object)node.getProperty("letter"));
        Assert.assertEquals((Object)Vowel.A.name(), (Object)node.getProperty("vowel"));
        Assert.assertEquals((Object)Consonant.B.ordinal(), (Object)node.getProperty("consonant"));
    }

    @NodeEntity
    static class Word {
        @GraphId
        Long id;
        @Indexed(unique=true, indexType=IndexType.LABEL)
        Letter letter;
        @GraphProperty(propertyType=String.class)
        Vowel vowel;
        @GraphProperty(propertyType=Integer.class)
        Consonant consonant;

        Word() {
        }

        Word(Letter letter, Vowel vowel, Consonant consonant) {
            this.letter = letter;
            this.vowel = vowel;
            this.consonant = consonant;
        }
    }

    static enum Consonant {
        B,
        C,
        D,
        F,
        G,
        H;

    }

    static enum Vowel {
        A,
        E,
        I,
        O,
        U;

    }

    static enum Letter {
        A,
        B,
        C;

    }

    @Configuration
    @EnableNeo4jRepositories
    static class TestConfig
    extends Neo4jConfiguration {
        TestConfig() {
            this.setBasePackage(new String[]{"org.springframework.data.neo4j.conversion"});
        }

        @Bean
        GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }
    }
}

