/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.conversion;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Slice;
import org.springframework.data.neo4j.annotation.MapResult;
import org.springframework.data.neo4j.conversion.DefaultConverter;
import org.springframework.data.neo4j.conversion.QueryResultBuilder;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.support.conversion.EntityResultConverter;

public class QueryResultBuilderTests {
    private final DefaultConverter defaultConverter = new DefaultConverter();
    private QueryResultBuilder<Integer> result = new QueryResultBuilder(Arrays.asList(1, 2, 3));

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testToWithConverter() throws Exception {
    }

    @Test
    public void testSingle() throws Exception {
        Assert.assertThat((Object)QueryResultBuilder.from((Object[])new Integer[]{1}).single(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSingleOrNull() throws Exception {
        QueryResultBuilder builder = new QueryResultBuilder(Collections.emptyList(), (ResultConverter)new EntityResultConverter(null));
        Assert.assertThat((Object)builder.to(TestResult.class).singleOrNull(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testTo() throws Exception {
    }

    @Test
    public void testAs() throws Exception {
        Map value1 = MapUtil.map((Object[])new Object[]{"key", 1});
        Map value2 = MapUtil.map((Object[])new Object[]{"key", 2});
        QueryResultBuilder builder = new QueryResultBuilder(Arrays.asList(value1, value2));
        List list = (List)builder.as(List.class);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertThat((Object)list, (Matcher)CoreMatchers.hasItems((Object[])new Map[]{value1, value2}));
        Page page = (Page)builder.as(Page.class);
        Assert.assertEquals((long)2L, (long)page.getNumberOfElements());
        Assert.assertThat((Object)page, (Matcher)CoreMatchers.hasItems((Object[])new Map[]{value1, value2}));
        Slice slice = (Slice)builder.as(Slice.class);
        Assert.assertEquals((long)2L, (long)slice.getNumberOfElements());
        Assert.assertThat((Object)page, (Matcher)CoreMatchers.hasItems((Object[])new Map[]{value1, value2}));
    }

    @Test
    public void testHandle() throws Exception {
    }

    @Test
    public void testIterator() throws Exception {
    }

    @MapResult
    static interface TestResult {
        public Integer getValue();
    }
}

