/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.entity;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.model.Group;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.repositories.FriendshipRepository;
import org.springframework.data.neo4j.repositories.GroupRepository;
import org.springframework.data.neo4j.repositories.PersonRepository;
import org.springframework.data.neo4j.repository.MatrixTeam;
import org.springframework.data.neo4j.repository.TestTeam;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
public class EntityQueryTests {
    @Autowired
    private Neo4jTemplate neo4jTemplate;
    @Autowired
    private PersonRepository personRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    FriendshipRepository friendshipRepository;
    @Autowired
    private PlatformTransactionManager transactionManager;
    private TestTeam testTeam;
    private MatrixTeam matrixTeam;

    @BeforeTransaction
    public void cleanDb() {
        Neo4jHelper.cleanDb(this.neo4jTemplate);
    }

    @Before
    public void setUp() throws Exception {
        this.testTeam = new TestTeam();
        this.matrixTeam = new MatrixTeam();
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                EntityQueryTests.this.personRepository.deleteAll();
                EntityQueryTests.this.groupRepository.deleteAll();
                EntityQueryTests.this.friendshipRepository.deleteAll();
                EntityQueryTests.this.testTeam.createSDGTeam(EntityQueryTests.this.personRepository, EntityQueryTests.this.groupRepository, EntityQueryTests.this.friendshipRepository);
                EntityQueryTests.this.matrixTeam.createMatrixTeam(EntityQueryTests.this.personRepository, EntityQueryTests.this.groupRepository, EntityQueryTests.this.friendshipRepository);
            }
        });
    }

    @Transactional
    @Test
    public void testPropertyQueryOfTypeSetPopulatedCorrectly() {
        Group grp = (Group)this.neo4jTemplate.findOne(this.matrixTeam.matrixGroup.getId().longValue(), Group.class);
        Set<Person> members = grp.getTeamMembersAsSetViaQuery();
        MatcherAssert.assertThat(members, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(members, (Matcher)Matchers.hasItems((Object[])new Person[]{this.matrixTeam.neo, this.matrixTeam.trinity, this.matrixTeam.cypher}));
        junit.framework.Assert.assertNull((Object)members.iterator().next().getName());
    }

    @Transactional
    @Test
    public void testPropertyQueryOfTypeIterablePopulatedCorrectly() {
        Group grp = (Group)this.neo4jTemplate.findOne(this.matrixTeam.matrixGroup.getId().longValue(), Group.class);
        Iterable<Person> itMembers = grp.getTeamMembersAsIterableViaQuery();
        Assert.assertNotNull(itMembers);
        Collection members = IteratorUtil.asCollection(itMembers);
        MatcherAssert.assertThat((Object)members, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)members, (Matcher)Matchers.hasItems((Object[])new Person[]{this.matrixTeam.neo, this.matrixTeam.trinity, this.matrixTeam.cypher}));
        junit.framework.Assert.assertNull((Object)((Person)members.iterator().next()).getName());
    }

    @Transactional
    @Test
    public void testRepositoryQueryOfTypeSetPopulatedCorrectly() {
        Set<Person> members = this.groupRepository.getTeamMembersAsSetViaQuery(this.matrixTeam.matrixGroup.getName());
        this.assertExpectionsOfMatrixTeamSetResult(members);
    }

    @Ignore(value="Bug in Neo4j 2.2.x")
    @Transactional
    @Test
    public void testNullParameterConversion() {
        Set<Person> members = this.groupRepository.getTeamMembersAsSetViaQuery(null);
        Assert.assertEquals((Object)true, (Object)members.isEmpty());
    }

    @Transactional
    @Test
    public void testFindByInQuery() {
        Set<Person> members = this.groupRepository.getTeamMembersByGroupNames(Arrays.asList(this.matrixTeam.matrixGroup.getName()));
        this.assertExpectionsOfMatrixTeamSetResult(members);
    }

    @Transactional
    @Test
    @Ignore(value="@Fetch breaks Neo4jEntityConverterTests - investigation required")
    public void testFetchedPropertyQueryOfTypeIterablePopulatedCorrectly() {
        Group grp = (Group)this.neo4jTemplate.findOne(this.matrixTeam.matrixGroup.getId().longValue(), Group.class);
        Iterable<Person> itMembers = grp.getFetchedTeamMembersAsIterableViaQuery();
        Collection members = IteratorUtil.asCollection(itMembers);
        this.assertExpectionsOfMatrixTeamSetResult(members);
    }

    @Transactional
    @Test
    @Ignore(value="@Fetch breaks Neo4jEntityConverterTests - investigation required")
    public void testFetchedPropertyQueryOfTypeSetPopulatedCorrectly() {
        Group grp = (Group)this.neo4jTemplate.findOne(this.matrixTeam.matrixGroup.getId().longValue(), Group.class);
        Set<Person> members = grp.getFetchedTeamMembersAsSetViaQuery();
        this.assertExpectionsOfMatrixTeamSetResult(members);
    }

    private void assertExpectionsOfMatrixTeamSetResult(Collection<Person> members) {
        MatcherAssert.assertThat(members, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(members, (Matcher)Matchers.hasItems((Object[])new Person[]{this.matrixTeam.neo, this.matrixTeam.trinity, this.matrixTeam.cypher}));
        Assert.assertNotNull((Object)members.iterator().next().getName());
    }
}

