/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.lifecycle.AfterDeleteEvent;
import org.springframework.data.neo4j.lifecycle.Program;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
@Transactional
public class AfterDeleteEventTests {
    @Autowired
    Neo4jTemplate template;
    @Autowired
    GraphDatabaseService graphDatabaseService;
    static Event lastEvent = Event.NONE;
    static List<Program> afterProgramDeleteEvents = new ArrayList<Program>();

    @BeforeTransaction
    public void beforeTransaction() {
        Neo4jHelper.cleanDb(this.template);
    }

    @Before
    public void before() {
        lastEvent = Event.NONE;
        afterProgramDeleteEvents.clear();
    }

    @Test
    public void shouldFireAfterEntityIsDeleted() throws Exception {
        Assert.assertEquals((Object)((Object)Event.NONE), (Object)((Object)lastEvent));
        Assert.assertThat(afterProgramDeleteEvents, (Matcher)Matchers.hasSize((int)0));
        Program sark = (Program)this.template.save((Object)new Program("Sark"));
        this.template.delete((Object)sark);
        Assert.assertThat(afterProgramDeleteEvents, (Matcher)Matchers.hasSize((int)1));
        Assert.assertEquals((Object)((Object)Event.AFTER_DELETE), (Object)((Object)lastEvent));
    }

    static enum Event {
        NONE,
        BEFORE_DELETE,
        AFTER_DELETE;

    }

    @Configuration
    @EnableNeo4jRepositories
    static class TestConfig
    extends Neo4jConfiguration {
        TestConfig() throws ClassNotFoundException {
            this.setBasePackage(new String[]{Program.class.getPackage().getName()});
        }

        @Bean
        GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }

        @Bean
        ApplicationListener<AfterDeleteEvent<Program>> afterDeleteEventApplicationListener() {
            return new ApplicationListener<AfterDeleteEvent<Program>>(){

                public void onApplicationEvent(AfterDeleteEvent<Program> event) {
                    afterProgramDeleteEvents.add((Program)event.getEntity());
                    lastEvent = Event.AFTER_DELETE;
                }
            };
        }
    }
}

