/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.lifecycle;

import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.lifecycle.AuditingEventListener;
import org.springframework.data.neo4j.lifecycle.BeforeSaveEvent;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.support.IsNewStrategyFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class AuditingEventListenerUnitTests {
    IsNewAwareAuditingHandler handler;
    IsNewStrategyFactory factory;
    AuditingEventListener listener;

    @Before
    public void setUp() {
        this.handler = (IsNewAwareAuditingHandler)Mockito.spy((Object)new IsNewAwareAuditingHandler((MappingContext)this.createContext()));
        this.listener = new AuditingEventListener((ObjectFactory)new ObjectFactory<IsNewAwareAuditingHandler>(){

            public IsNewAwareAuditingHandler getObject() throws BeansException {
                return AuditingEventListenerUnitTests.this.handler;
            }
        });
    }

    protected Neo4jMappingContext createContext() {
        Neo4jMappingContext mappingContext = new Neo4jMappingContext();
        mappingContext.setInitialEntitySet(Collections.singleton(Sample.class));
        mappingContext.afterPropertiesSet();
        return mappingContext;
    }

    @Test(expected=IllegalArgumentException.class)
    public void rejectsNullAuditingHandler() {
        new AuditingEventListener(null);
    }

    @Test
    public void triggersCreationMarkForObjectWithEmptyId() {
        Sample sample = new Sample();
        this.listener.onApplicationEvent(new BeforeSaveEvent((Object)this, (Object)sample));
        ((IsNewAwareAuditingHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).markCreated((Object)sample);
        ((IsNewAwareAuditingHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)0))).markModified(Mockito.any(Sample.class));
    }

    @Test
    public void triggersModificationMarkForObjectWithSetId() {
        Sample sample = new Sample();
        sample.id = "id";
        this.listener.onApplicationEvent(new BeforeSaveEvent((Object)this, (Object)sample));
        ((IsNewAwareAuditingHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)0))).markCreated(Mockito.any(Sample.class));
        ((IsNewAwareAuditingHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).markModified((Object)sample);
    }

    @NodeEntity
    static class Sample {
        @GraphId
        String id;

        Sample() {
        }
    }
}

