/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.lifecycle;

import java.util.LinkedList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.lifecycle.DeleteEvent;
import org.springframework.data.neo4j.lifecycle.DeprecatedProgram;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.annotation.Transactional;

@Deprecated
@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
@Transactional
public class DeleteEventTests {
    @Autowired
    Neo4jTemplate template;
    @Autowired
    GraphDatabaseService graphDatabaseService;
    static final LinkedList<DeprecatedProgram> deletions = new LinkedList();

    @BeforeTransaction
    public void beforeTransaction() {
        Neo4jHelper.cleanDb(this.template);
    }

    @Before
    public void before() {
        deletions.clear();
    }

    @Test
    public void shouldFireEventOnNodeDeletion() throws Exception {
        DeprecatedProgram sark = (DeprecatedProgram)this.template.save((Object)new DeprecatedProgram("Sark"));
        this.template.delete((Object)sark);
        Assert.assertThat(deletions, (Matcher)CoreMatchers.hasItem((Object)sark));
    }

    @Configuration
    @EnableNeo4jRepositories
    static class TestConfig
    extends Neo4jConfiguration {
        TestConfig() throws ClassNotFoundException {
            this.setBasePackage(new String[]{DeprecatedProgram.class.getPackage().getName()});
        }

        @Bean
        GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }

        @Bean
        ApplicationListener<DeleteEvent<DeprecatedProgram>> deleteEventApplicationListener() {
            return new ApplicationListener<DeleteEvent<DeprecatedProgram>>(){

                public void onApplicationEvent(DeleteEvent<DeprecatedProgram> event) {
                    deletions.add((DeprecatedProgram)event.getEntity());
                }
            };
        }
    }
}

