/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.Before;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.convert.DefaultTypeMapper;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.config.BasePackageScanner;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.core.TypeRepresentationStrategy;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactoryFactory;
import org.springframework.data.neo4j.fieldaccess.Neo4jConversionServiceFactoryBean;
import org.springframework.data.neo4j.fieldaccess.NodeDelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.RelationshipDelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.mapping.EntityInstantiator;
import org.springframework.data.neo4j.model.Group;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.support.DelegatingGraphDatabase;
import org.springframework.data.neo4j.support.Infrastructure;
import org.springframework.data.neo4j.support.MappingInfrastructureFactoryBean;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.index.IndexProvider;
import org.springframework.data.neo4j.support.index.IndexProviderImpl;
import org.springframework.data.neo4j.support.mapping.DefaultEntityIndexCreator;
import org.springframework.data.neo4j.support.mapping.EntityIndexCreator;
import org.springframework.data.neo4j.support.mapping.EntityStateHandler;
import org.springframework.data.neo4j.support.mapping.EntityTools;
import org.springframework.data.neo4j.support.mapping.Neo4jEntityFetchHandler;
import org.springframework.data.neo4j.support.mapping.Neo4jEntityPersister;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.mapping.SourceStateTransmitter;
import org.springframework.data.neo4j.support.mapping.TRSTypeAliasAccessor;
import org.springframework.data.neo4j.support.node.EntityStateFactory;
import org.springframework.data.neo4j.support.node.NodeEntityInstantiator;
import org.springframework.data.neo4j.support.node.NodeEntityStateFactory;
import org.springframework.data.neo4j.support.relationship.RelationshipEntityInstantiator;
import org.springframework.data.neo4j.support.relationship.RelationshipEntityStateFactory;
import org.springframework.data.neo4j.support.schema.SchemaIndexProvider;
import org.springframework.data.neo4j.support.typerepresentation.ClassValueTypeInformationMapper;
import org.springframework.data.neo4j.support.typerepresentation.NoopNodeTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.typerepresentation.NoopRelationshipTypeRepresentationStrategy;

public class Neo4jPersistentTestBase {
    private Transaction tx;
    protected Neo4jTemplate template;
    protected EntityStateHandler entityStateHandler;
    protected NodeEntityInstantiator nodeEntityInstantiator;
    protected RelationshipEntityInstantiator relationshipEntityInstantiator;
    protected TypeMapper<Node> nodeTypeMapper;
    protected SourceStateTransmitter<Node> nodeStateTransmitter;
    protected SourceStateTransmitter<Relationship> relationshipStateTransmitter;
    protected ConversionService conversionService;
    protected Neo4jEntityFetchHandler fetchHandler;
    protected Neo4jMappingContext mappingContext;
    protected Neo4jEntityPersister entityPersister;
    protected Group group;
    protected Person michael;
    protected Person emil;
    protected Person andres;
    public static final RelationshipType PERSONS = DynamicRelationshipType.withName((String)"persons");
    protected static final RelationshipType KNOWS = DynamicRelationshipType.withName((String)"knows");

    @Before
    public void setUp() throws Exception {
        this.mappingContext = new Neo4jMappingContext();
        Infrastructure infrastructure = this.createInfrastructure(this.mappingContext);
        this.template = new Neo4jTemplate(infrastructure);
        this.conversionService = this.template.getConversionService();
        this.tx = this.template.getGraphDatabase().beginTx();
        this.group = new Group();
        this.michael = new Person("Michael", 37);
        this.emil = new Person("Emil", 30);
        this.andres = new Person("Andr\u00e9s", 36);
    }

    private Infrastructure createInfrastructure(Neo4jMappingContext mappingContext) throws Exception {
        MappingInfrastructureFactoryBean factoryBean = new MappingInfrastructureFactoryBean();
        GraphDatabaseService gdb = new TestGraphDatabaseFactory().newImpermanentDatabase();
        factoryBean.setGraphDatabaseService(gdb);
        DelegatingGraphDatabase graphDatabase = new DelegatingGraphDatabase(gdb);
        factoryBean.setGraphDatabase((GraphDatabase)graphDatabase);
        factoryBean.setMappingContext(mappingContext);
        EntityStateHandler entityStateHandler = new EntityStateHandler(mappingContext, (GraphDatabase)graphDatabase, this.conversionService);
        NoopNodeTypeRepresentationStrategy nodeTypeRepresentationStrategy = new NoopNodeTypeRepresentationStrategy();
        factoryBean.setNodeTypeRepresentationStrategy((TypeRepresentationStrategy)nodeTypeRepresentationStrategy);
        NoopRelationshipTypeRepresentationStrategy relationshipTypeRepresentationStrategy = new NoopRelationshipTypeRepresentationStrategy();
        factoryBean.setRelationshipTypeRepresentationStrategy((TypeRepresentationStrategy)relationshipTypeRepresentationStrategy);
        factoryBean.setConversionService(new Neo4jConversionServiceFactoryBean().getObject());
        factoryBean.setEntityStateHandler(entityStateHandler);
        NodeEntityStateFactory nodeEntityStateFactory = new NodeEntityStateFactory(mappingContext, new FieldAccessorFactoryFactory(){

            public DelegatingFieldAccessorFactory create(Neo4jTemplate template) {
                return new NodeDelegatingFieldAccessorFactory(template);
            }
        });
        RelationshipEntityStateFactory relationshipEntityStateFactory = new RelationshipEntityStateFactory(mappingContext, new FieldAccessorFactoryFactory(){

            public DelegatingFieldAccessorFactory create(Neo4jTemplate template) {
                return new RelationshipDelegatingFieldAccessorFactory(template);
            }
        });
        factoryBean.setNodeEntityStateFactory((EntityStateFactory)nodeEntityStateFactory);
        factoryBean.setRelationshipEntityStateFactory((EntityStateFactory)relationshipEntityStateFactory);
        mappingContext.setEntityIndexCreator((EntityIndexCreator)new DefaultEntityIndexCreator((IndexProvider)new IndexProviderImpl((GraphDatabase)graphDatabase), new SchemaIndexProvider((GraphDatabase)graphDatabase), true));
        mappingContext.setSimpleTypeHolder(null);
        this.setBasePackage(mappingContext);
        this.nodeEntityInstantiator = new NodeEntityInstantiator(entityStateHandler);
        this.relationshipEntityInstantiator = new RelationshipEntityInstantiator(entityStateHandler);
        this.nodeTypeMapper = new DefaultTypeMapper((TypeAliasAccessor)new TRSTypeAliasAccessor((TypeRepresentationStrategy)nodeTypeRepresentationStrategy), Arrays.asList(new ClassValueTypeInformationMapper()));
        this.nodeStateTransmitter = new SourceStateTransmitter((EntityStateFactory)nodeEntityStateFactory);
        this.relationshipStateTransmitter = new SourceStateTransmitter((EntityStateFactory)relationshipEntityStateFactory);
        this.fetchHandler = new Neo4jEntityFetchHandler(entityStateHandler, this.conversionService, this.nodeStateTransmitter, this.relationshipStateTransmitter);
        EntityTools nodeEntityTools = new EntityTools((TypeRepresentationStrategy)nodeTypeRepresentationStrategy, (EntityStateFactory)nodeEntityStateFactory, (EntityInstantiator)this.nodeEntityInstantiator, mappingContext);
        EntityTools relationshipEntityTools = new EntityTools((TypeRepresentationStrategy)relationshipTypeRepresentationStrategy, (EntityStateFactory)relationshipEntityStateFactory, (EntityInstantiator)this.relationshipEntityInstantiator, mappingContext);
        this.entityPersister = new Neo4jEntityPersister(this.conversionService, nodeEntityTools, relationshipEntityTools, mappingContext, entityStateHandler);
        mappingContext.afterPropertiesSet();
        factoryBean.afterPropertiesSet();
        return factoryBean.getObject();
    }

    protected void setBasePackage(Neo4jMappingContext mappingContext) throws ClassNotFoundException {
        this.setBasePackage(mappingContext, this.getClass().getPackage().getName());
    }

    protected void setBasePackage(Neo4jMappingContext mappingContext, String ... basePackages) throws ClassNotFoundException {
        mappingContext.setInitialEntitySet(BasePackageScanner.scanBasePackageForClasses((String[])basePackages));
    }

    protected List<Node> groupMemberNodes() {
        return this.groupMemberNodes(this.groupNode());
    }

    private List<Node> groupMemberNodes(Node node) {
        return this.getRelatedNodes(node, "persons", Direction.OUTGOING);
    }

    @After
    public void tearDown() throws Exception {
        if (this.tx != null) {
            this.tx.failure();
            this.tx.close();
        }
        this.template.getGraphDatabaseService().shutdown();
    }

    protected Node michaelNode() {
        return this.template.getNode(this.michael.getId().longValue());
    }

    protected Node createNewNode() {
        return this.template.createNode();
    }

    protected Group storeInGraph(Group g) {
        Long id = g.getId();
        if (id != null) {
            this.write(g, this.template.getNode(id.longValue()));
        } else {
            this.write(g, null);
        }
        return g;
    }

    protected Person storeInGraph(Person p) {
        Long id = p.getId();
        if (id != null) {
            this.write(p, this.template.getNode(id.longValue()));
        } else {
            this.write(p, null);
        }
        return p;
    }

    protected Object write(Object entity, Node node) {
        this.entityPersister.write(entity, node, this.template.getMappingPolicy(entity), this.template, null);
        return entity;
    }

    private <T> T storeInGraph(T obj) {
        return (T)this.write(obj, null);
    }

    protected Node groupNode() {
        return this.template.getNode(this.group.getId().longValue());
    }

    protected <T> Set<T> set(T ... objs) {
        return new HashSet<T>(Arrays.asList(objs));
    }

    protected <T> Set<T> set(Iterable<T> objs) {
        return (Set)IteratorUtil.addToCollection(objs, new HashSet());
    }

    protected Node andresNode() {
        return this.template.getNode(this.andres.getId().longValue());
    }

    protected Node emilNode() {
        return this.template.getNode(this.emil.getId().longValue());
    }

    public Person readPerson(Node node) {
        return (Person)this.entityPersister.read(Person.class, node, this.template.getMappingPolicy(Person.class), this.template);
    }

    protected Relationship makeFriends(Node from, Node to, int years) {
        Relationship friendship = from.createRelationshipTo(to, KNOWS);
        friendship.setProperty("Friendship.years", (Object)years);
        return friendship;
    }

    public Group readGroup(Node node) {
        return (Group)this.entityPersister.read(Group.class, node, this.template.getMappingPolicy(Group.class), this.template);
    }

    protected List<Node> getRelatedNodes(Node startNode, String type, Direction direction) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Relationship relationship : startNode.getRelationships((RelationshipType)DynamicRelationshipType.withName((String)type), direction)) {
            result.add(relationship.getOtherNode(startNode));
        }
        return result;
    }

    @NodeEntity
    public static class Developer {
        @GraphId
        public Long id;
        public String name;
    }
}

