/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.model;

import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.Max;
import org.springframework.data.neo4j.annotation.EndNode;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.Indexed;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.annotation.RelationshipType;
import org.springframework.data.neo4j.annotation.StartNode;
import org.springframework.data.neo4j.fieldaccess.DynamicProperties;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.support.index.IndexType;

@RelationshipEntity(useShortNames=false)
public class Friendship
implements Serializable {
    private static final long serialVersionUID = 1L;
    @GraphId
    private Long id;
    @StartNode
    private Person p1;
    @EndNode
    private Person p2;
    @RelationshipType
    private String type;
    @Indexed(indexType=IndexType.SIMPLE)
    @Max(value=75L)
    private int years;
    private Date firstMeetingDate;
    private DynamicProperties personalProperties;
    private transient String latestLocation;

    public Friendship() {
    }

    public Friendship(Person p1, Person p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    public Friendship(Person p1, Person p2, int years) {
        this.p1 = p1;
        this.p2 = p2;
        this.years = years;
    }

    public Friendship(Person start, Person end, String type) {
        this.p1 = start;
        this.p2 = end;
        this.type = type;
    }

    public void setPerson1(Person p) {
        this.p1 = p;
    }

    public Person getPerson1() {
        return this.p1;
    }

    public void setPerson2(Person p) {
        this.p2 = p;
    }

    public Person getPerson2() {
        return this.p2;
    }

    public void setYears(int years) {
        this.years = years;
    }

    public int getYears() {
        return this.years;
    }

    public void setFirstMeetingDate(Date firstMeetingDate) {
        this.firstMeetingDate = firstMeetingDate;
    }

    public Date getFirstMeetingDate() {
        return this.firstMeetingDate;
    }

    public void setLatestLocation(String latestLocation) {
        this.latestLocation = latestLocation;
    }

    public String getLatestLocation() {
        return this.latestLocation;
    }

    public void setPersonalProperties(DynamicProperties personalProperties) {
        this.personalProperties = personalProperties;
    }

    public DynamicProperties getPersonalProperties() {
        return this.personalProperties;
    }

    public Long getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Friendship friendship = (Friendship)o;
        if (this.id == null) {
            return super.equals(o);
        }
        return this.id.equals(friendship.id);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }
}

