/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.mapping.PersistentEntityConversionException;
import org.springframework.data.neo4j.model.AbstractNodeEntity;
import org.springframework.data.neo4j.model.Concrete1NodeEntity;
import org.springframework.data.neo4j.model.Concrete2NodeEntity;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.repositories.AbstractNodeEntityRepository;
import org.springframework.data.neo4j.repositories.PersonRepository;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
public class AbstractEntityBasedGraphRepositoryTests {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Neo4jTemplate neo4jTemplate;
    @Autowired
    private PersonRepository personRepository;
    @Autowired
    AbstractNodeEntityRepository abstractNodeEntityRepository;

    @BeforeTransaction
    public void cleanDb() {
        Neo4jHelper.cleanDb(this.neo4jTemplate);
    }

    @Transactional
    @Test(expected=PersistentEntityConversionException.class)
    public void testInvalidEntityLoadAttemptThroughAbstractRepoThrowsAppropriateException() {
        Person person = (Person)this.personRepository.save(new Person("someone", 30));
        AbstractNodeEntity shouldNotWork = (AbstractNodeEntity)this.abstractNodeEntityRepository.findOne(person.getId());
    }

    @Test
    @Transactional
    public void testConcreteEntityLoadedThroughAbstractRepoLoadsCorrectType() {
        Concrete1NodeEntity origConcrete1 = new Concrete1NodeEntity("concrete1A");
        Concrete2NodeEntity origConcrete2 = new Concrete2NodeEntity("concrete2A");
        this.abstractNodeEntityRepository.save(origConcrete1);
        this.abstractNodeEntityRepository.save(origConcrete2);
        Concrete1NodeEntity loadedConcrete1 = (Concrete1NodeEntity)this.abstractNodeEntityRepository.findOne(origConcrete1.id);
        Assert.assertNotNull((Object)loadedConcrete1);
        Assert.assertThat((Object)loadedConcrete1, (Matcher)Matchers.is((Object)origConcrete1));
        Concrete2NodeEntity loadedConcrete2 = (Concrete2NodeEntity)this.abstractNodeEntityRepository.findOne(origConcrete2.id);
        Assert.assertNotNull((Object)loadedConcrete2);
        Assert.assertThat((Object)loadedConcrete2, (Matcher)Matchers.is((Object)origConcrete2));
    }
}

