/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.geo.Shape;
import org.springframework.data.neo4j.repository.GeoConverter;

public class GeoQueriesTest {
    @Test
    public void testBoxToPolygon() throws Exception {
        Polygon polygon = GeoConverter.toPolygon((Box)new Box(new Point(0.0, 0.0), new Point(100.0, 100.0)));
        Assert.assertEquals(Arrays.asList(new Point(0.0, 0.0), new Point(100.0, 0.0), new Point(100.0, 100.0), new Point(0.0, 100.0)), (Object)polygon.getPoints());
    }

    @Test
    public void testCircleToPolygon() throws Exception {
        Polygon polygon = GeoConverter.toPolygon((Circle)new Circle(new Point(13.0, 52.0), new Distance(69.0, (Metric)Metrics.MILES)), (int)4);
        List<Point> expected = Arrays.asList(new Point(14.624269, 52.0), new Point(13.0, 53.0), new Point(11.375731, 52.0), new Point(13.0, 51.0));
        List points = polygon.getPoints();
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i).toString(), (Object)((Point)points.get(i)).toString());
        }
    }

    @Test
    public void testPointToWkt() throws Exception {
        Assert.assertEquals((Object)"POINT(100.0 30.0)", (Object)GeoConverter.toWellKnownText((Point)new Point(100.0, 30.0)));
    }

    @Test
    public void testBoxToWkt() throws Exception {
        Assert.assertEquals((Object)"POLYGON((30.0 30.0,100.0 30.0,100.0 100.0,30.0 100.0,30.0 30.0))", (Object)GeoConverter.toWellKnownText((Shape)new Box(new Point(30.0, 30.0), new Point(100.0, 100.0))));
    }

    @Test
    public void textPolygonFromWkt() throws Exception {
        Assert.assertEquals((Object)GeoConverter.toPolygon((Box)new Box(new Point(30.0, 30.0), new Point(100.0, 100.0))), (Object)GeoConverter.fromWellKnownText((String)"POLYGON((30.0 30.0,100.0 30.0,100.0 100.0,30.0 100.0,30.0 30.0))"));
    }

    @Test
    public void testWktToPoint() throws Exception {
        Assert.assertEquals((Object)new Point(100.0, 30.1), (Object)GeoConverter.pointFromWellKnownText((String)"POINT (100 30.1 ) "));
    }
}

