/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.model.Group;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.repositories.GroupRepository;
import org.springframework.data.neo4j.repositories.PersonRepository;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"classpath:org/springframework/data/neo4j/repository/GraphRepositoryTests-context.xml"})
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
public class NoIndexDerivedFinderTests {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PersonRepository personRepository;
    @Autowired
    private GroupRepository groupRepository;

    @Test
    @Transactional
    public void findByAge() {
        Iterable<Person> result = this.personRepository.findByAge(0);
        Assert.assertEquals((long)0L, (long)IteratorUtil.count(result));
    }

    @Test
    @Transactional
    public void findAllInitiallyWithoutIndexCreation() {
        Result<Person> result = this.personRepository.findByHeight((short)100);
        Assert.assertEquals((long)0L, (long)IteratorUtil.count(result));
    }

    @Test
    @Transactional
    public void findFullTextWithoutIndexCreation() {
        Iterable<Group> result = this.groupRepository.findByFullTextNameLike("foo");
        Assert.assertEquals((long)0L, (long)IteratorUtil.count(result));
    }

    @Test
    @Transactional
    public void findByName() {
        Iterable<Person> result = this.personRepository.findByName("");
        Assert.assertEquals((long)0L, (long)IteratorUtil.count(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithSeparateTransactions() throws Exception {
        final GraphDatabaseService gdb = new TestGraphDatabaseFactory().newImpermanentDatabase();
        Thread t = new Thread(){

            @Override
            public void run() {
                Transaction tx = gdb.beginTx();
                Index index = gdb.index().forNodes("Test");
                Assert.assertEquals((Object)"Test", (Object)gdb.index().nodeIndexNames()[0]);
                tx.success();
                tx.close();
            }
        };
        t.start();
        t.join();
        Transaction tx = gdb.beginTx();
        try {
            ExecutionResult result = new ExecutionEngine(gdb).execute("start n=node:Test('name:*') return n");
            Assert.assertEquals((long)0L, (long)IteratorUtil.count((Iterable)result));
            Assert.assertEquals((Object)"Test", (Object)gdb.index().nodeIndexNames()[0]);
        }
        finally {
            tx.success();
            tx.close();
        }
    }
}

