/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.repositories.RedeclaringRepositoryMethodsRepository;
import org.springframework.data.neo4j.repository.AbstractEntityBasedGraphRepositoryTests;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class RedeclaringRepositoryMethodsTests
extends AbstractEntityBasedGraphRepositoryTests {
    @Autowired
    RedeclaringRepositoryMethodsRepository repository;

    @Test
    public void adjustedWellKnownPagedFindAllMethodShouldReturnOnlyTheUserWithFirstnameOliver() {
        Person ollie = (Person)this.repository.save(new Person("Oliver", 30));
        this.repository.save(new Person("Thomas", 30));
        Page<Person> page = this.repository.findAll((Pageable)new PageRequest(0, 2));
        Assert.assertThat((Object)page.getNumberOfElements(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Person)page.getContent().get(0)).getName(), (Matcher)CoreMatchers.is((Object)ollie.getName()));
    }

    @Test
    public void adjustedWllKnownFindAllMethodShouldReturnAnEmptyList() {
        this.repository.save(new Person("Oliver", 30));
        this.repository.save(new Person("Thomas", 30));
        Result<Person> result = this.repository.findAll();
        Assert.assertThat((Object)result.iterator().hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }
}

