/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.helpers.collection.IteratorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.fieldaccess.ManagedFieldAccessorSet;
import org.springframework.data.neo4j.fieldaccess.ManagedPrefixedDynamicProperties;
import org.springframework.data.neo4j.fieldaccess.PrefixedDynamicProperties;
import org.springframework.data.neo4j.model.Friendship;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.repositories.FriendshipRepository;
import org.springframework.data.neo4j.repositories.GroupRepository;
import org.springframework.data.neo4j.repositories.PersonRepository;
import org.springframework.data.neo4j.repository.MemberDataPOJO;
import org.springframework.data.neo4j.repository.SerialTesters;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.data.neo4j.template.GraphCallback;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
public class SerializableEntityRepositoryTests {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private Neo4jTemplate neo4jTemplate;
    @Autowired
    private PersonRepository personRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    FriendshipRepository friendshipRepository;
    private SerialTesters serialTesters;
    private Date expectedBirthDate;

    @BeforeTransaction
    public void cleanDb() {
        Neo4jHelper.cleanDb(this.neo4jTemplate);
    }

    @Before
    public void setUp() throws Exception {
        this.serialTesters = new SerialTesters();
        this.serialTesters.createUpgraderTeam(this.personRepository, this.groupRepository, this.friendshipRepository);
        this.expectedBirthDate = this.serialTesters.bdayFormatter.parse("01 01 2013 00:00:00");
    }

    @Test
    public void shouldBeAbleToSerializeAndDeserializeBasicEntityGraph() throws Exception {
        Person person = (Person)this.personRepository.findOne(this.serialTesters.nicki.getId());
        this.assertEntityDetailsForPerson(person);
        Assert.assertThat((Object)person, (Matcher)Matchers.instanceOf(Serializable.class));
        byte[] bos = this.serializeIt(person);
        Person aDeserializedPerson = (Person)this.deserializeIt(bos);
        this.assertEntityDetailsForPerson(aDeserializedPerson);
    }

    @Test
    public void primitiveFieldShouldBeSerializedInOriginalForm() throws Exception {
        Person deserializedPerson = this.assertPreSerializationSetupThenGetDeserializedPerson();
        Assert.assertEquals(String.class, deserializedPerson.getName().getClass());
        Assert.assertEquals((Object)"Nicki", (Object)deserializedPerson.getName());
    }

    @Test
    public void primitiveFieldUpdatedOnDeserializedEntityShouldBeAbleToBeSavedBackToRepo() throws Exception {
        final Person deserializedPerson = this.assertPreSerializationSetupThenGetDeserializedPerson();
        Assert.assertEquals(String.class, deserializedPerson.getName().getClass());
        Assert.assertEquals((Object)"Nicki", (Object)deserializedPerson.getName());
        deserializedPerson.setName("New Name");
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                SerializableEntityRepositoryTests.this.personRepository.save(deserializedPerson);
            }
        });
        Person personFromDB = (Person)this.personRepository.findOne(deserializedPerson.getId());
        Assert.assertEquals((Object)"New Name", (Object)personFromDB.getName());
    }

    @Test
    public void managedFieldAkaRelationshipsShouldBeSerializedAsAHashSet() throws Exception {
        Person deserializedPerson = this.assertPreSerializationSetupThenGetDeserializedPerson();
        Assert.assertEquals(HashSet.class, deserializedPerson.getSerialFriends().getClass());
        Assert.assertEquals((long)1L, (long)deserializedPerson.getSerialFriends().size());
        Assert.assertThat(deserializedPerson.getSerialFriends(), (Matcher)Matchers.hasItem((Object)this.serialTesters.michael));
    }

    @Test
    public void managedFieldAkaRelationshipUpdatedOnDeserializedEntityShouldBeAbleToBeSavedBackToRepo() throws Exception {
        final Person deserializedPerson = this.assertPreSerializationSetupThenGetDeserializedPerson();
        Assert.assertEquals(HashSet.class, deserializedPerson.getSerialFriends().getClass());
        Assert.assertEquals((long)1L, (long)deserializedPerson.getSerialFriends().size());
        Assert.assertThat(deserializedPerson.getSerialFriends(), (Matcher)Matchers.hasItem((Object)this.serialTesters.michael));
        deserializedPerson.addSerialFriend(this.serialTesters.david);
        Assert.assertEquals((long)2L, (long)deserializedPerson.getSerialFriends().size());
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                SerializableEntityRepositoryTests.this.personRepository.save(deserializedPerson);
            }
        });
        Person personFromDB = (Person)this.personRepository.findOne(deserializedPerson.getId());
        Assert.assertEquals((long)2L, (long)personFromDB.getSerialFriends().size());
        Assert.assertThat(personFromDB.getSerialFriends(), (Matcher)Matchers.hasItem((Object)this.serialTesters.michael));
        Assert.assertThat(personFromDB.getSerialFriends(), (Matcher)Matchers.hasItem((Object)this.serialTesters.david));
    }

    @Test
    public void dynamicPropertiesFieldShouldBeSerializedAsAPrefixedDynamicProperties() throws Exception {
        Person deserializedPerson = this.assertPreSerializationSetupThenGetDeserializedPerson();
        Assert.assertEquals(PrefixedDynamicProperties.class, deserializedPerson.getPersonalProperties().getClass());
        Assert.assertEquals((long)2L, (long)deserializedPerson.getPersonalProperties().asMap().size());
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)deserializedPerson.getPersonalProperties().getPropertyKeys()), (Matcher)Matchers.hasItems((Object[])new String[]{"addressLine1", "addressLine2"}));
    }

    @Test
    public void dynamicPropertiesFieldUpdatedOnDeserializedEntityShouldBeAbleToBeSavedBackToRepo() throws Exception {
        final Person deserializedPerson = this.assertPreSerializationSetupThenGetDeserializedPerson();
        Assert.assertEquals(PrefixedDynamicProperties.class, deserializedPerson.getPersonalProperties().getClass());
        Assert.assertEquals((long)2L, (long)deserializedPerson.getPersonalProperties().asMap().size());
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)deserializedPerson.getPersonalProperties().getPropertyKeys()), (Matcher)Matchers.hasItems((Object[])new String[]{"addressLine1", "addressLine2"}));
        deserializedPerson.setProperty("newDynoProp", "newDynoValue");
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                SerializableEntityRepositoryTests.this.personRepository.save(deserializedPerson);
            }
        });
        Person personFromDB = (Person)this.personRepository.findOne(deserializedPerson.getId());
        Assert.assertEquals((long)3L, (long)personFromDB.getPersonalProperties().asMap().size());
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)personFromDB.getPersonalProperties().getPropertyKeys()), (Matcher)Matchers.hasItems((Object[])new String[]{"addressLine1", "addressLine2", "newDynoProp"}));
    }

    private Person assertPreSerializationSetupThenGetDeserializedPerson() throws Exception {
        return (Person)this.neo4jTemplate.exec((GraphCallback)new GraphCallback<Person>(){

            public Person doWithGraph(GraphDatabase graph) throws Exception {
                SerializableEntityRepositoryTests.this.addSerialFriend(((SerializableEntityRepositoryTests)SerializableEntityRepositoryTests.this).serialTesters.nicki.getId(), ((SerializableEntityRepositoryTests)SerializableEntityRepositoryTests.this).serialTesters.michael);
                Person person = (Person)SerializableEntityRepositoryTests.this.personRepository.findOne(((SerializableEntityRepositoryTests)SerializableEntityRepositoryTests.this).serialTesters.nicki.getId());
                Assert.assertEquals(ManagedFieldAccessorSet.class, person.getSerialFriends().getClass());
                Assert.assertEquals((long)1L, (long)person.getSerialFriends().size());
                Assert.assertEquals(ManagedPrefixedDynamicProperties.class, person.getPersonalProperties().getClass());
                Assert.assertEquals((long)2L, (long)person.getPersonalProperties().asMap().size());
                Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)person.getPersonalProperties().getPropertyKeys()), (Matcher)Matchers.hasItems((Object[])new String[]{"addressLine1", "addressLine2"}));
                byte[] bos = SerializableEntityRepositoryTests.this.serializeIt(person);
                return (Person)SerializableEntityRepositoryTests.this.deserializeIt(bos);
            }
        });
    }

    private void addSerialFriend(final Long sourcePersonId, final Person target) {
        this.neo4jTemplate.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                Person person1 = (Person)SerializableEntityRepositoryTests.this.personRepository.findOne(sourcePersonId);
                person1.addSerialFriend(target);
                SerializableEntityRepositoryTests.this.personRepository.save(person1);
            }
        });
    }

    public void assertPOJOContainsExpectedData(MemberDataPOJO pojo) throws Exception {
        Assert.assertNotNull((Object)pojo);
        Assert.assertThat((Object)pojo.getBoss(), (Matcher)Matchers.is((Object)this.serialTesters.tareq));
        Assert.assertThat((Object)IteratorUtil.asCollection(pojo.getTeams()), (Matcher)Matchers.hasItem((Object)this.serialTesters.serialTesterGroup));
        Assert.assertThat((Object)pojo.getAnInt(), (Matcher)Matchers.is((Object)this.serialTesters.tareq.getAge()));
        Assert.assertThat((Object)pojo.getAName(), (Matcher)Matchers.is((Object)this.serialTesters.tareq.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> byte[] serializeIt(T someObject) throws Exception {
        try (ObjectOutputStream out = null;){
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(bos);
            out.writeObject(someObject);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T deserializeIt(byte[] serializedBytes) throws Exception {
        try (ObjectInputStream in = null;){
            Object theNewObj;
            ByteArrayInputStream bis = new ByteArrayInputStream(serializedBytes);
            in = new ObjectInputStream(bis);
            Object object = theNewObj = in.readObject();
            return (T)object;
        }
    }

    private void assertEntityDetailsForPerson(Person aPerson) {
        Assert.assertThat((Object)aPerson.getAge(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)36)));
        Assert.assertThat((Object)aPerson.getBoss(), (Matcher)Matchers.is((Object)this.serialTesters.tareq));
        Assert.assertThat((Object)aPerson.getBirthdate(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.expectedBirthDate)));
        Assert.assertThat((Object)aPerson.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Nicki")));
        Assert.assertThat((Object)aPerson.getDynamicProperty(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"What is this???")));
        Assert.assertThat(aPerson.getFriendships(), (Matcher)Matchers.hasItems((Object[])new Friendship[]{this.serialTesters.friendShip2, this.serialTesters.friendShip3}));
        Assert.assertThat((Object)aPerson.getHeight(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)100)));
        Assert.assertThat((Object)aPerson.getProperty("addressLine1"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Somewhere")));
        Assert.assertThat((Object)aPerson.getProperty("addressLine2"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Over the rainbow")));
    }
}

