/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.cdi;

import java.lang.annotation.Annotation;
import org.apache.webbeans.cditest.CdiTestContainer;
import org.apache.webbeans.cditest.CdiTestContainerLoader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.repository.cdi.CdiPersonRepository;
import org.springframework.data.neo4j.repository.cdi.CdiPersonRepository2;
import org.springframework.data.neo4j.repository.cdi.CdiPersonRepository3;
import org.springframework.data.neo4j.repository.cdi.RepositoryClient;

@Ignore
public class CdiExtensionIntegrationTests {
    static CdiTestContainer container;

    @BeforeClass
    public static void setUp() throws Exception {
        container = CdiTestContainerLoader.getCdiContainer();
        container.bootContainer();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        container.shutdownContainer();
    }

    @Test
    public void testRepositoryStyle1IsCreatedCorrectly() {
        GraphDatabase database = (GraphDatabase)container.getInstance(GraphDatabase.class, new Annotation[0]);
        RepositoryClient client = (RepositoryClient)container.getInstance(RepositoryClient.class, new Annotation[0]);
        CdiPersonRepository repository = client.repository;
        Assert.assertThat((Object)repository, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Person person = null;
        Person result = null;
        try (Transaction tx = database.beginTx();){
            repository.deleteAll();
            person = new Person("Simon", 28);
            result = repository.save(person);
            tx.success();
        }
        tx = database.beginTx();
        var7_7 = null;
        try {
            Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            Long resultId = result.getId();
            Person lookedUpPerson = repository.findOne(person.getId());
            Assert.assertThat((Object)lookedUpPerson.getId(), (Matcher)CoreMatchers.is((Object)resultId));
            tx.success();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void testRepositoryStyle2IsCreatedCorrectly() {
        GraphDatabase database = (GraphDatabase)container.getInstance(GraphDatabase.class, new Annotation[0]);
        RepositoryClient client = (RepositoryClient)container.getInstance(RepositoryClient.class, new Annotation[0]);
        CdiPersonRepository2 repository = client.repository2;
        Assert.assertThat((Object)repository, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Person person = null;
        Person result = null;
        try (Transaction tx = database.beginTx();){
            repository.deleteAll();
            person = new Person("Simon", 28);
            result = (Person)repository.save(person);
            tx.success();
        }
        tx = database.beginTx();
        var7_7 = null;
        try {
            Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            Long resultId = result.getId();
            Person lookedUpPerson = (Person)repository.findOne(person.getId());
            Assert.assertThat((Object)lookedUpPerson.getId(), (Matcher)CoreMatchers.is((Object)resultId));
            tx.success();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void neo4jCrudRepositorySubTypeWorks() {
        GraphDatabase database = (GraphDatabase)container.getInstance(GraphDatabase.class, new Annotation[0]);
        RepositoryClient client = (RepositoryClient)container.getInstance(RepositoryClient.class, new Annotation[0]);
        CdiPersonRepository3 repository = client.repository3;
        Assert.assertThat((Object)repository, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Person person = null;
        Person result = null;
        try (Transaction tx = database.beginTx();){
            repository.deleteAll();
            person = new Person("Simon", 28);
            result = (Person)repository.save(person);
            tx.success();
        }
        tx = database.beginTx();
        var7_7 = null;
        try {
            Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            Long resultId = result.getId();
            Person lookedUpPerson = (Person)repository.findOne(person.getId());
            Assert.assertThat((Object)lookedUpPerson.getId(), (Matcher)CoreMatchers.is((Object)resultId));
            tx.success();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void returnOneFromCustomImpl() {
        GraphDatabase database = (GraphDatabase)container.getInstance(GraphDatabase.class, new Annotation[0]);
        try (Transaction tx = database.beginTx();){
            RepositoryClient client = (RepositoryClient)container.getInstance(RepositoryClient.class, new Annotation[0]);
            Assert.assertThat((Object)client.samplePersonRepository.returnOne(), (Matcher)CoreMatchers.is((Object)1));
        }
    }
}

