/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.repository.query.CypherQueryBuilder;
import org.springframework.data.neo4j.repository.query.Person;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.repository.query.parser.Part;

public abstract class AbstractCypherQueryBuilderTestBase {
    protected String trsSpecificExpectedQuery;
    protected CypherQueryBuilder query;
    static final String CLASS_NAME = Person.class.getSimpleName();

    @Before
    public void setUp() {
        Neo4jMappingContext context = new Neo4jMappingContext();
        Neo4jTemplate template = (Neo4jTemplate)Mockito.mock(Neo4jTemplate.class);
        this.finishMock(template);
        this.query = new CypherQueryBuilder((MappingContext)context, Person.class, template);
        this.trsSpecificExpectedQuery = null;
    }

    protected void finishMock(Neo4jTemplate template) {
    }

    @Test
    public void createsQueryForSimplePropertyReference() {
        Part part = new Part("name", Person.class);
        this.query.addRestriction(part);
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.getExpectedQuery("MATCH (`person`:`Person`) WHERE `person`.`name` = {0} RETURN `person`")));
    }

    @Test
    public void createsQueryForSimpleIndexedPropertyReference() {
        Part part = new Part("name2", Person.class);
        this.query.addRestriction(part);
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.getExpectedQuery("START `person`=node:`Person`(`name2`={0}) RETURN `person`")));
    }

    @Test
    public void createsQueryForLikePropertyIndex() {
        Part part = new Part("titleLike", Person.class);
        this.query.addRestriction(part);
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.getExpectedQuery("START `person`=node:`title`({0}) RETURN `person`")));
    }

    @Test
    public void createsQueryForLikeProperty() {
        Part part = new Part("infoLike", Person.class);
        this.query.addRestriction(part);
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.getExpectedQuery("trs-specific-test-subclass-expected-to-set-value")));
    }

    @Test
    public void createsQueryForGreaterThanPropertyReference() {
        Part part = new Part("ageGreaterThan", Person.class);
        this.query.addRestriction(part);
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.getExpectedQuery("trs-specific-test-subclass-expected-to-set-value")));
    }

    @Test
    public void createsQueryForTwoPropertyExpressions() {
        this.query.addRestriction(new Part("ageGreaterThan", Person.class));
        this.query.addRestriction(new Part("info", Person.class));
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.getExpectedQuery("trs-specific-test-subclass-expected-to-set-value")));
    }

    @Test
    public void createsQueryForIsNullPropertyReference() {
        Part part = new Part("ageIsNull", Person.class);
        this.query.addRestriction(part);
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.getExpectedQuery("trs-specific-test-subclass-expected-to-set-value")));
    }

    @Test
    public void createsQueryForPropertyOnRelationShipReference() {
        Part part = new Part("group.name", Person.class);
        this.query.addRestriction(part);
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.getExpectedQuery("trs-specific-test-subclass-expected-to-set-value")));
    }

    @Test
    public void createsQueryForMultipleStartClauses() {
        this.query.addRestriction(new Part("name", Person.class));
        this.query.addRestriction(new Part("group.name", Person.class));
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.getExpectedQuery("trs-specific-test-subclass-expected-to-set-value")));
    }

    @Test
    public void createsSimpleWhereClauseCorrectly() {
        this.query.addRestriction(new Part("age", Person.class));
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.getExpectedQuery("trs-specific-test-subclass-expected-to-set-value")));
    }

    @Test
    public void createsSimpleTraversalClauseCorrectly() {
        this.query.addRestriction(new Part("group", Person.class));
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.getExpectedQuery("trs-specific-test-subclass-expected-to-set-value")));
    }

    @Test
    public void buildsComplexQueryCorrectly() {
        this.query.addRestriction(new Part("name", Person.class));
        this.query.addRestriction(new Part("groupName", Person.class));
        this.query.addRestriction(new Part("ageGreaterThan", Person.class));
        this.query.addRestriction(new Part("groupMembersAge", Person.class));
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.getExpectedQuery("trs-specific-test-subclass-expected-to-set-value")));
    }

    @Test
    public void buildsQueryWithSort() {
        this.query.addRestriction(new Part("name", Person.class));
        String queryString = this.query.buildQuery(new Sort(new String[]{"person.name"})).toQueryString();
        Assert.assertThat((Object)queryString, (Matcher)CoreMatchers.is((Object)"MATCH (`person`:`Person`) WHERE `person`.`name` = {0} RETURN `person` ORDER BY person.name ASC"));
    }

    @Test
    public void buildsQueryWithTwoSorts() {
        this.query.addRestriction(new Part("name", Person.class));
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order("person.name"), new Sort.Order(Sort.Direction.DESC, "person.age")});
        String queryString = this.query.buildQuery(sort).toQueryString();
        Assert.assertThat((Object)queryString, (Matcher)CoreMatchers.is((Object)"MATCH (`person`:`Person`) WHERE `person`.`name` = {0} RETURN `person` ORDER BY person.name ASC,person.age DESC"));
    }

    @Test
    public void buildsQueryWithPage() {
        this.query.addRestriction(new Part("name", Person.class));
        PageRequest pageable = new PageRequest(3, 10, new Sort(new String[]{"person.name"}));
        String queryString = this.query.buildQuery().toQueryString((Pageable)pageable);
        Assert.assertThat((Object)queryString, (Matcher)CoreMatchers.is((Object)"MATCH (`person`:`Person`) WHERE `person`.`name` = {0} RETURN `person` ORDER BY person.name ASC SKIP 30 LIMIT 10"));
    }

    @Test
    public void shouldFindByNodeEntity() throws Exception {
        this.query.addRestriction(new Part("pet", Person.class));
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.getExpectedQuery("trs-specific-test-subclass-expected-to-set-value")));
    }

    @Test
    public void shouldFindByNodeEntityForIncomingRelationship() {
        this.query.addRestriction(new Part("group", Person.class));
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.getExpectedQuery("trs-specific-test-subclass-expected-to-set-value")));
    }

    private String getExpectedQuery(String defaultQueryString) {
        return this.trsSpecificExpectedQuery != null ? this.trsSpecificExpectedQuery : defaultQueryString;
    }
}

