/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.repository.query.AbstractCypherQueryBuilderTestBase;
import org.springframework.data.neo4j.repository.query.Person;
import org.springframework.data.repository.query.parser.Part;

public class CypherQueryBuilderForIndexBasedTRSUnitTests
extends AbstractCypherQueryBuilderTestBase {
    private static final String DEFAULT_START_CLAUSE = "START `person`=node:__types__(className=\"" + CLASS_NAME + "\")";

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    @Override
    @Test
    public void createsQueryForLikeProperty() {
        this.trsSpecificExpectedQuery = DEFAULT_START_CLAUSE + " WHERE `person`.`info` =~ {0} RETURN `person`";
        super.createsQueryForLikeProperty();
    }

    @Override
    @Test
    public void createsQueryForGreaterThanPropertyReference() {
        this.trsSpecificExpectedQuery = DEFAULT_START_CLAUSE + " WHERE `person`.`age` > {0} RETURN `person`";
        super.createsQueryForGreaterThanPropertyReference();
    }

    @Override
    @Test
    public void createsQueryForTwoPropertyExpressions() {
        this.trsSpecificExpectedQuery = DEFAULT_START_CLAUSE + " WHERE `person`.`age` > {0} AND `person`.`info` = {1} RETURN `person`";
        super.createsQueryForTwoPropertyExpressions();
    }

    @Override
    @Test
    public void createsQueryForIsNullPropertyReference() {
        this.trsSpecificExpectedQuery = DEFAULT_START_CLAUSE + " WHERE `person`.`age` is null  RETURN `person`";
        super.createsQueryForIsNullPropertyReference();
    }

    @Override
    @Test
    public void createsQueryForPropertyOnRelationShipReference() {
        this.trsSpecificExpectedQuery = "START `person_group`=node:`Group`(`name2`={0}) MATCH (`person`)<-[:`members`]-(`person_group`) RETURN `person`";
        Part part = new Part("group.name2", Person.class);
        this.query.addRestriction(part);
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.trsSpecificExpectedQuery));
    }

    @Override
    @Test
    public void createsQueryForMultipleStartClauses() {
        this.trsSpecificExpectedQuery = "START `person`=node:`Person`(`name2`={0}), `person_group`=node:`Group`(`name2`={1}) MATCH (`person`)<-[:`members`]-(`person_group`) RETURN `person`";
        this.query.addRestriction(new Part("name2", Person.class));
        this.query.addRestriction(new Part("group.name2", Person.class));
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.trsSpecificExpectedQuery));
    }

    @Override
    public void createsQueryForSimplePropertyReference() {
        Part part = new Part("name2", Person.class);
        this.query.addRestriction(part);
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)"START `person`=node:`Person`(`name2`={0}) RETURN `person`"));
    }

    @Override
    @Test
    public void createsSimpleWhereClauseCorrectly() {
        this.trsSpecificExpectedQuery = DEFAULT_START_CLAUSE + " WHERE `person`.`age` = {0} RETURN `person`";
        super.createsSimpleWhereClauseCorrectly();
    }

    @Override
    @Test
    public void createsSimpleTraversalClauseCorrectly() {
        this.trsSpecificExpectedQuery = "START `person_group`=node({0}) MATCH (`person`)<-[:`members`]-(`person_group`) WHERE `person`.__type__ IN ['Person'] RETURN `person`";
        super.createsSimpleTraversalClauseCorrectly();
    }

    @Override
    @Test
    public void buildsComplexQueryCorrectly() {
        this.trsSpecificExpectedQuery = "START `person`=node:`Person`(`name2`={0}), `person_group`=node:`Group`(`name2`={1}) MATCH (`person`)<-[:`members`]-(`person_group`), (`person`)<-[:`members`]-(`person_group`)-[:`members`]->(`person_group_members`) WHERE `person`.`age` > {2} AND `person_group_members`.`age` = {3} RETURN `person`";
        this.query.addRestriction(new Part("name2", Person.class));
        this.query.addRestriction(new Part("group_Name2", Person.class));
        this.query.addRestriction(new Part("ageGreaterThan", Person.class));
        this.query.addRestriction(new Part("groupMembersAge", Person.class));
        Assert.assertThat((Object)this.query.toString(), (Matcher)CoreMatchers.is((Object)this.trsSpecificExpectedQuery));
    }

    @Override
    @Test
    public void shouldFindByNodeEntity() throws Exception {
        this.trsSpecificExpectedQuery = "START `person_pet`=node({0}) MATCH (`person`)-[:`owns`]->(`person_pet`) WHERE `person`.__type__ IN ['Person'] RETURN `person`";
        super.shouldFindByNodeEntity();
    }

    @Override
    @Test
    public void shouldFindByNodeEntityForIncomingRelationship() {
        this.trsSpecificExpectedQuery = "START `person_group`=node({0}) MATCH (`person`)<-[:`members`]-(`person_group`) WHERE `person`.__type__ IN ['Person'] RETURN `person`";
        super.shouldFindByNodeEntityForIncomingRelationship();
    }

    @Override
    public void buildsQueryWithSort() {
        this.query.addRestriction(new Part("name2", Person.class));
        String queryString = this.query.buildQuery(new Sort(new String[]{"person.name2"})).toQueryString();
        Assert.assertThat((Object)queryString, (Matcher)CoreMatchers.is((Object)"START `person`=node:`Person`(`name2`={0}) RETURN `person` ORDER BY person.name2 ASC"));
    }

    @Override
    public void buildsQueryWithTwoSorts() {
        this.query.addRestriction(new Part("name2", Person.class));
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order("person.name2"), new Sort.Order(Sort.Direction.DESC, "person.age")});
        String queryString = this.query.buildQuery(sort).toQueryString();
        Assert.assertThat((Object)queryString, (Matcher)CoreMatchers.is((Object)"START `person`=node:`Person`(`name2`={0}) RETURN `person` ORDER BY person.name2 ASC,person.age DESC"));
    }

    @Override
    public void buildsQueryWithPage() {
        this.query.addRestriction(new Part("name2", Person.class));
        PageRequest pageable = new PageRequest(3, 10, new Sort(new String[]{"person.name2"}));
        String queryString = this.query.buildQuery().toQueryString((Pageable)pageable);
        Assert.assertThat((Object)queryString, (Matcher)CoreMatchers.is((Object)"START `person`=node:`Person`(`name2`={0}) RETURN `person` ORDER BY person.name2 ASC SKIP 30 LIMIT 10"));
    }
}

