/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.neo4j.repository.query.MatchClause;
import org.springframework.data.neo4j.repository.query.Person;
import org.springframework.data.neo4j.repository.query.VariableContext;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;

@Ignore(value="until merged with DATAGRAPH-113")
public class MatchClauseUnitTests {
    Neo4jMappingContext context;
    private VariableContext variableContext;

    @Before
    public void setUp() {
        this.context = new Neo4jMappingContext();
        this.context.setInitialEntitySet(Collections.singleton(Person.class));
        this.context.initialize();
        this.variableContext = new VariableContext();
    }

    @Test
    public void buildsMatchExpressionForSimpleTraversalCorrectly() {
        PropertyPath path = PropertyPath.from((String)"group", Person.class);
        MatchClause clause = new MatchClause(this.context.getPersistentPropertyPath(path));
        Assert.assertThat((Object)clause.toString(this.variableContext), (Matcher)CoreMatchers.is((Object)"person<-[:members]-person_group"));
    }

    @Test
    public void createsMatchClassForDeepTraversal() {
        PropertyPath path = PropertyPath.from((String)"group.members.age", Person.class);
        MatchClause clause = new MatchClause(this.context.getPersistentPropertyPath(path));
        Assert.assertThat((Object)clause.toString(this.variableContext), (Matcher)CoreMatchers.is((Object)"person<-[:members]-person_group-[:members]->person_group_members"));
    }

    @Test
    public void stopsAtNonRelationShipPropertyPath() {
        PropertyPath path = PropertyPath.from((String)"group.name", Person.class);
        MatchClause clause = new MatchClause(this.context.getPersistentPropertyPath(path));
        Assert.assertThat((Object)clause.toString(this.variableContext), (Matcher)CoreMatchers.is((Object)"person<-[:members]-person_group"));
    }
}

