/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.cypher;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.repository.query.cypher.SimpleTypeArrayEntity;
import org.springframework.data.neo4j.repository.query.cypher.SimpleTypeArrayEntityRepository;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
public class InParameterisedByArrayOfSimpleTypeTests {
    public static final byte[] BYTES = new byte[]{66, 67};
    public static final boolean[] BOOLEANS = new boolean[]{true, false};
    public static final short[] SHORTS = new short[]{23, 24};
    public static final int[] INTS = new int[]{63, 64};
    public static final long[] LONGS = new long[]{87L, 88L};
    public static final float[] FLOATS = new float[]{3.14f, 3.15f};
    public static final double[] DOUBLES = new double[]{2.97, 2.98};
    public static final char[] CHARS = new char[]{'!', '@'};
    public static final String[] STRINGS = new String[]{"dub", "idub"};
    @Autowired
    GraphDatabaseService graphDatabaseService;
    @Autowired
    SimpleTypeArrayEntityRepository simpleTypeArrayEntityRepository;

    @Before
    public void before() {
        Neo4jHelper.cleanDb(this.graphDatabaseService, true);
        Transaction transaction = this.graphDatabaseService.beginTx();
        try {
            this.simpleTypeArrayEntityRepository.save(new SimpleTypeArrayEntity());
            this.simpleTypeArrayEntityRepository.save(new SimpleTypeArrayEntity(BOOLEANS, BYTES, SHORTS, INTS, LONGS, FLOATS, DOUBLES, CHARS, STRINGS));
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    @Test
    public void shouldSupportStringArraysAsParameterForIn() throws Exception {
        Assert.assertThat((Object)this.simpleTypeArrayEntityRepository.findUsingString(Arrays.asList(new String[][]{InParameterisedByArrayOfSimpleTypeTests.STRINGS, {"foo"}})).strings, (Matcher)CoreMatchers.is((Object)STRINGS));
    }

    @Test
    public void shouldSupportBooleanArrayAsParameterForIn() throws Exception {
        Assert.assertThat((Object)this.simpleTypeArrayEntityRepository.findUsingBoolean(Arrays.asList(new boolean[][]{InParameterisedByArrayOfSimpleTypeTests.BOOLEANS})).booleans, (Matcher)CoreMatchers.is((Object)BOOLEANS));
    }

    @Test
    public void shouldSupportByteArrayAsParameterForIn() throws Exception {
        Assert.assertThat((Object)this.simpleTypeArrayEntityRepository.findUsingByte(Arrays.asList(new byte[][]{InParameterisedByArrayOfSimpleTypeTests.BYTES})).bytes, (Matcher)CoreMatchers.is((Object)BYTES));
    }

    @Test
    public void shouldSupportShortArrayAsParameterForIn() throws Exception {
        Assert.assertThat((Object)this.simpleTypeArrayEntityRepository.findUsingShort(Arrays.asList(new short[][]{InParameterisedByArrayOfSimpleTypeTests.SHORTS})).shorts, (Matcher)CoreMatchers.is((Object)SHORTS));
    }

    @Test
    public void shouldSupportIntArrayAsParameterForIn() throws Exception {
        Assert.assertThat((Object)this.simpleTypeArrayEntityRepository.findUsingInt(Arrays.asList(new int[][]{InParameterisedByArrayOfSimpleTypeTests.INTS})).ints, (Matcher)CoreMatchers.is((Object)INTS));
    }

    @Test
    public void shouldSupportLongArrayAsParameterForIn() throws Exception {
        Assert.assertThat((Object)this.simpleTypeArrayEntityRepository.findUsingLong(Arrays.asList(new long[][]{InParameterisedByArrayOfSimpleTypeTests.LONGS})).longs, (Matcher)CoreMatchers.is((Object)LONGS));
    }

    @Test
    public void shouldSupportFloatArrayAsParameterForIn() throws Exception {
        Assert.assertThat((Object)this.simpleTypeArrayEntityRepository.findUsingFloat(Arrays.asList(new float[][]{InParameterisedByArrayOfSimpleTypeTests.FLOATS})).floats, (Matcher)CoreMatchers.is((Object)FLOATS));
    }

    @Test
    public void shouldSupportDoubleArrayAsParameterForIn() throws Exception {
        Assert.assertThat((Object)this.simpleTypeArrayEntityRepository.findUsingDouble(Arrays.asList(new double[][]{InParameterisedByArrayOfSimpleTypeTests.DOUBLES})).doubles, (Matcher)CoreMatchers.is((Object)DOUBLES));
    }

    @Test
    public void shouldSupportCharArrayAsParameterForIn() throws Exception {
        Assert.assertThat((Object)this.simpleTypeArrayEntityRepository.findUsingChar(Arrays.asList(new char[][]{InParameterisedByArrayOfSimpleTypeTests.CHARS})).chars, (Matcher)CoreMatchers.is((Object)CHARS));
    }

    @Configuration
    @EnableNeo4jRepositories
    static class TestConfig
    extends Neo4jConfiguration {
        TestConfig() throws ClassNotFoundException {
            this.setBasePackage(new String[]{SimpleTypeArrayEntity.class.getPackage().getName()});
        }

        @Bean
        GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }
    }
}

