/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.data.neo4j.model.AbstractNodeEntity;
import org.springframework.data.neo4j.model.Concrete1NodeEntity;
import org.springframework.data.neo4j.model.Concrete2NodeEntity;
import org.springframework.data.neo4j.model.Group;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.support.EntityTestBase;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:template-config-context-with-type-safety-returning-null.xml"})
public class NullReturningTypeSafetyNeo4jTemplateTests
extends EntityTestBase {
    private Neo4jOperations neo4jOperations;

    @Before
    public void setUp() throws Exception {
        this.createTeam();
        this.neo4jOperations = this.template;
    }

    @Test
    @Transactional
    public void testFindOneWithWrongTypeReturnsNull() throws Exception {
        Group found = (Group)this.neo4jOperations.findOne(this.testTeam.michael.getId().longValue(), Group.class);
        Assert.assertNull((Object)found);
    }

    @Test
    @Transactional
    public void testFindOneWithRightTypeReturnsPerson() throws Exception {
        Person found = (Person)this.neo4jOperations.findOne(this.testTeam.michael.getId().longValue(), Person.class);
        Assert.assertNotNull((Object)found);
    }

    @Test(expected=DataRetrievalFailureException.class)
    @Transactional
    public void testFindOneWithNonExistingIdThrowsDataRetrievalFailureException() throws Exception {
        this.neo4jOperations.findOne(Long.MAX_VALUE, Person.class);
    }

    @Test
    @Transactional
    public void testFindOneWithAbstractWrongTypeReturnsNull() throws Exception {
        AbstractNodeEntity entity = (AbstractNodeEntity)this.neo4jOperations.findOne(this.testTeam.michael.getId().longValue(), AbstractNodeEntity.class);
        Assert.assertNull((Object)entity);
    }

    @Test
    @Transactional
    public void testFindOneWithConcreteEntityAndConcreteTypeReturnsConcreteEntity() throws Exception {
        AbstractNodeEntity origConcrete1NodeEntity = (AbstractNodeEntity)this.neo4jOperations.save((Object)new Concrete1NodeEntity("concrete1"));
        AbstractNodeEntity readConcrete1NodeEntity = (AbstractNodeEntity)this.neo4jOperations.findOne(origConcrete1NodeEntity.id.longValue(), Concrete1NodeEntity.class);
        Assert.assertNotNull((Object)readConcrete1NodeEntity);
        Assert.assertEquals((Object)origConcrete1NodeEntity, (Object)readConcrete1NodeEntity);
    }

    @Test
    @Transactional
    public void testFindOneWithConcreteEntityAndAbstractTypeReturnsConcreteEntity() throws Exception {
        Concrete1NodeEntity origConcrete1NodeEntity = (Concrete1NodeEntity)this.neo4jOperations.save((Object)new Concrete1NodeEntity("concrete1"));
        Concrete1NodeEntity readConcrete1NodeEntity = (Concrete1NodeEntity)this.neo4jOperations.findOne(origConcrete1NodeEntity.id.longValue(), AbstractNodeEntity.class);
        Assert.assertNotNull((Object)readConcrete1NodeEntity);
        Assert.assertEquals((Object)origConcrete1NodeEntity, (Object)readConcrete1NodeEntity);
    }

    @Test
    @Transactional
    public void testFindOneWithDifferentConcreteEntitiesReturnsNull() throws Exception {
        Concrete2NodeEntity origConcrete2NodeEntity = (Concrete2NodeEntity)this.neo4jOperations.save((Object)new Concrete2NodeEntity("concrete2"));
        AbstractNodeEntity readConcrete2NodeEntity = (AbstractNodeEntity)this.neo4jOperations.findOne(origConcrete2NodeEntity.id.longValue(), Concrete1NodeEntity.class);
        Assert.assertNull((Object)readConcrete2NodeEntity);
    }
}

