/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.data.neo4j.support.Infrastructure;
import org.springframework.data.neo4j.support.MappingInfrastructureFactoryBean;

public class EntityRemoverTest {
    @Test
    public void testRemoveNodeEntityWithAutoIndex() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        try (Transaction tx = db.beginTx();){
            AutoIndexer nodeAutoIndexer = db.index().getNodeAutoIndexer();
            nodeAutoIndexer.setEnabled(true);
            nodeAutoIndexer.startAutoIndexingProperty("foo");
            Infrastructure infrastructure = MappingInfrastructureFactoryBean.createDirect((GraphDatabaseService)db, null);
            Node node = db.createNode();
            node.setProperty("foo", (Object)"bar");
            infrastructure.getEntityRemover().remove((Object)node);
            node = db.createNode();
            node.setProperty("foo", (Object)"bar");
            infrastructure.getGraphDatabase().remove(node);
            tx.success();
        }
    }

    @Test
    public void testRemoveRelationshipEntityWithAutoIndex() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        try (Transaction tx = db.beginTx();){
            RelationshipAutoIndexer autoIndexer = db.index().getRelationshipAutoIndexer();
            autoIndexer.setEnabled(true);
            autoIndexer.startAutoIndexingProperty("foo");
            Infrastructure infrastructure = MappingInfrastructureFactoryBean.createDirect((GraphDatabaseService)db, null);
            Node node = db.createNode();
            Relationship relationship = node.createRelationshipTo(node, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            relationship.setProperty("foo", (Object)"bar");
            infrastructure.getEntityRemover().remove((Object)relationship);
            relationship = node.createRelationshipTo(node, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            relationship.setProperty("foo", (Object)"bar");
            infrastructure.getGraphDatabase().remove(relationship);
            tx.success();
        }
    }
}

