/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.Traversal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.data.neo4j.template.GraphCallback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:template-config-context.xml"})
public class FullNeo4jTemplateTests {
    private static final DynamicRelationshipType KNOWS = DynamicRelationshipType.withName((String)"knows");
    private static final DynamicRelationshipType HAS = DynamicRelationshipType.withName((String)"has");
    @Autowired
    Neo4jTemplate neo4jTemplate;
    @Autowired
    protected GraphDatabase graphDatabase;
    protected Node node0;
    protected Relationship relationship1;
    protected Node node1;
    @Autowired
    PlatformTransactionManager neo4jTransactionManager;

    @BeforeTransaction
    public void cleanDb() {
        Neo4jHelper.cleanDb(this.neo4jTemplate);
    }

    @Before
    public void setUp() throws Exception {
        try (Transaction tx = this.neo4jTemplate.getGraphDatabase().beginTx();){
            Neo4jHelper.cleanDb(this.neo4jTemplate);
            tx.success();
        }
        tx = this.neo4jTemplate.getGraphDatabase().beginTx();
        try {
            this.createData();
            tx.success();
        }
        finally {
            tx.close();
        }
    }

    private void createData() {
        new TransactionTemplate(this.neo4jTransactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                FullNeo4jTemplateTests.this.node0 = FullNeo4jTemplateTests.this.graphDatabase.createNode(MapUtil.map((Object[])new Object[]{"name", "node0"}), Arrays.asList("Node"));
                FullNeo4jTemplateTests.this.graphDatabase.createIndex(Node.class, "node", IndexType.SIMPLE).add((PropertyContainer)FullNeo4jTemplateTests.this.node0, "name", (Object)"node0");
                FullNeo4jTemplateTests.this.node1 = FullNeo4jTemplateTests.this.graphDatabase.createNode(MapUtil.map((Object[])new Object[]{"name", "node1"}), Arrays.asList("Node"));
                FullNeo4jTemplateTests.this.relationship1 = FullNeo4jTemplateTests.this.node0.createRelationshipTo(FullNeo4jTemplateTests.this.node1, (RelationshipType)KNOWS);
                FullNeo4jTemplateTests.this.relationship1.setProperty("name", (Object)"rel1");
                FullNeo4jTemplateTests.this.graphDatabase.createIndex(Relationship.class, "relationship", IndexType.SIMPLE).add((PropertyContainer)FullNeo4jTemplateTests.this.relationship1, "name", (Object)"rel1");
            }
        });
    }

    @Test
    public void shouldExecuteCallbackInTransaction() throws Exception {
        Node refNode = (Node)this.neo4jTemplate.exec((GraphCallback)new GraphCallback<Node>(){

            public Node doWithGraph(GraphDatabase graph) throws Exception {
                Node referenceNode = graph.getNodeById(FullNeo4jTemplateTests.this.node0.getId());
                referenceNode.setProperty("test", (Object)"testDoInTransaction");
                return referenceNode;
            }
        });
        Transaction tx = this.graphDatabase.beginTx();
        try {
            Assert.assertEquals((String)"same reference node", (Object)this.node0, (Object)refNode);
            this.assertTestPropertySet(this.node0, "testDoInTransaction");
        }
        finally {
            tx.success();
            tx.finish();
        }
    }

    @Test
    public void shouldRollbackTransactionOnException() {
        try {
            this.neo4jTemplate.exec((GraphCallback)new GraphCallback.WithoutResult(){

                public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                    graph.getNodeById(FullNeo4jTemplateTests.this.node0.getId()).setProperty("test", (Object)"shouldRollbackTransactionOnException");
                    throw new RuntimeException("please rollback");
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Transaction tx = this.graphDatabase.beginTx();
        try {
            Assert.assertThat((Object)((String)this.node0.getProperty("test", (Object)"not set")), (Matcher)CoreMatchers.not((Object)"shouldRollbackTransactionOnException"));
        }
        finally {
            tx.success();
            tx.finish();
        }
    }

    @Test
    public void shouldRollbackViaStatus() throws Exception {
        new TransactionTemplate(this.neo4jTransactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(final TransactionStatus status) {
                FullNeo4jTemplateTests.this.neo4jTemplate.exec((GraphCallback)new GraphCallback.WithoutResult(){

                    public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                        FullNeo4jTemplateTests.this.node0.setProperty("test", (Object)"shouldRollbackTransactionOnException");
                        status.setRollbackOnly();
                    }
                });
            }
        });
        Transaction tx = this.graphDatabase.beginTx();
        try {
            Assert.assertThat((Object)((String)this.node0.getProperty("test", (Object)"not set")), (Matcher)CoreMatchers.not((Object)"shouldRollbackTransactionOnException"));
        }
        finally {
            tx.success();
            tx.finish();
        }
    }

    @Test(expected=RuntimeException.class)
    public void shouldNotConvertUserRuntimeExceptionToDataAccessException() {
        this.neo4jTemplate.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                throw new RuntimeException();
            }
        });
    }

    @Test(expected=DataAccessException.class)
    @Ignore
    public void shouldConvertMissingTransactionExceptionToDataAccessException() {
        Neo4jTemplate template = new Neo4jTemplate(this.graphDatabase, null);
        template.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                graph.createNode(null, null);
            }
        });
    }

    @Test(expected=DataAccessException.class)
    public void shouldConvertNotFoundExceptionToDataAccessException() {
        Neo4jTemplate template = new Neo4jTemplate(this.graphDatabase, this.neo4jTransactionManager);
        template.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                graph.getNodeById(Long.MAX_VALUE);
            }
        });
    }

    @Test(expected=DataAccessException.class)
    public void shouldConvertTemplateNotFoundExceptionToDataAccessException() {
        this.neo4jTemplate.getNode(Long.MAX_VALUE);
    }

    @Test
    @Transactional
    public void shouldExecuteCallback() throws Exception {
        Long refNodeId = (Long)this.neo4jTemplate.exec((GraphCallback)new GraphCallback<Long>(){

            public Long doWithGraph(GraphDatabase graph) throws Exception {
                return graph.getNodeById(FullNeo4jTemplateTests.this.node0.getId()).getId();
            }
        });
        Assert.assertEquals((long)this.node0.getId(), (long)refNodeId);
    }

    @Test
    @Transactional
    public void testCreateNode() throws Exception {
        Node node = this.neo4jTemplate.createNode(null);
        Assert.assertNotNull((String)"created node", (Object)node);
    }

    @Test
    @Transactional
    public void testCreateEntityWithProperties() throws Exception {
        Person person = (Person)this.neo4jTemplate.createNodeAs(Person.class, MapUtil.map((Object[])new Object[]{"name", "name"}));
        Assert.assertNotNull((String)"created node", (Object)person);
        Assert.assertEquals((String)"property created", (Object)"name", (Object)person.getName());
    }

    @Test
    @Transactional
    public void testCreateNodeTypeWithProperties() throws Exception {
        Node person = (Node)this.neo4jTemplate.createNodeAs(Node.class, MapUtil.map((Object[])new Object[]{"name", "name"}));
        Assert.assertNotNull((String)"created node", (Object)person);
        Assert.assertEquals((String)"property created", (Object)"name", (Object)person.getProperty("name"));
    }

    @Test
    @Transactional
    public void testCreateNodeWithProperties() throws Exception {
        Node node = this.neo4jTemplate.createNode(MapUtil.map((Object[])new Object[]{"test", "testCreateNodeWithProperties"}));
        this.assertTestPropertySet(node, "testCreateNodeWithProperties");
    }

    private void assertTestPropertySet(Node node, String testName) {
        Assert.assertEquals((Object)testName, (Object)node.getProperty("test", (Object)"not set"));
    }

    @Test
    @Transactional
    public void testGetNode() throws Exception {
        Node lookedUpNode = this.neo4jTemplate.getNode(this.node0.getId());
        Assert.assertEquals((Object)this.node0, (Object)lookedUpNode);
    }

    @Test
    @Transactional
    public void testGetRelationship() throws Exception {
        Relationship lookedUpRelationship = this.neo4jTemplate.getRelationship(this.relationship1.getId());
        Assert.assertThat((Object)lookedUpRelationship, (Matcher)CoreMatchers.is((Object)this.relationship1));
    }

    @Test
    @Transactional
    public void testIndexRelationship() throws Exception {
        Index index = this.graphDatabase.getIndex("relationship");
        Relationship lookedUpRelationship = (Relationship)index.get("name", (Object)"rel1").getSingle();
        Assert.assertThat((String)"same relationship from index", (Object)lookedUpRelationship, (Matcher)CoreMatchers.is((Object)this.relationship1));
    }

    @Test
    @Transactional
    public void testIndexNode() throws Exception {
        this.neo4jTemplate.index("node", (PropertyContainer)this.node1, "name", (Object)"node1");
        Index index = this.graphDatabase.getIndex("node");
        Node lookedUpNode = (Node)index.get("name", (Object)"node1").getSingle();
        Assert.assertThat((String)"same node from index", (Object)lookedUpNode, (Matcher)CoreMatchers.is((Object)this.node1));
    }

    @Test
    @Transactional
    public void testQueryNodes() throws Exception {
        this.assertSingleResult((Object)"node0", (Iterable)this.neo4jTemplate.lookup("node", (Object)new TermQuery(new Term("name", "node0"))).to(String.class, (ResultConverter)new PropertyContainerNameConverter()));
    }

    @Test
    @Transactional
    public void testRetrieveNodes() throws Exception {
        this.assertSingleResult((Object)"node0", (Iterable)this.neo4jTemplate.lookup("node", "name", (Object)"node0").to(String.class, (ResultConverter)new PropertyContainerNameConverter()));
    }

    @Test
    @Transactional
    public void testQueryRelationships() throws Exception {
        this.assertSingleResult((Object)"rel1", (Iterable)this.neo4jTemplate.lookup("relationship", (Object)new TermQuery(new Term("name", "rel1"))).to(String.class, (ResultConverter)new PropertyContainerNameConverter()));
    }

    @Test
    @Transactional
    public void testRetrieveRelationships() throws Exception {
        this.assertSingleResult((Object)"rel1", (Iterable)this.neo4jTemplate.lookup("relationship", "name", (Object)"rel1").to(String.class, (ResultConverter)new PropertyContainerNameConverter()));
    }

    @Test
    @Transactional
    public void testTraverse() throws Exception {
        TraversalDescription description = Traversal.description().relationships((RelationshipType)KNOWS).evaluator(Evaluators.toDepth((int)1)).evaluator(Evaluators.excludeStartPosition());
        this.assertSingleResult((Object)"node1", (Iterable)this.neo4jTemplate.traverse(this.node0, description).to(String.class, (ResultConverter)new PathNodeNameMapper()));
    }

    @Test
    @Transactional
    public void shouldFindNextNodeViaCypher() throws Exception {
        this.assertSingleResult((Object)this.node1, (Iterable)this.neo4jTemplate.query("start n=node(" + this.node0.getId() + ") match n-[:knows]->m return m", null).to(Node.class));
    }

    @Test
    @Transactional
    public void shouldGetDirectRelationship() throws Exception {
        this.assertSingleResult((Object)"rel1", (Iterable)this.neo4jTemplate.convert(this.node0.getRelationships(new RelationshipType[]{DynamicRelationshipType.withName((String)"knows")})).to(String.class, (ResultConverter)new RelationshipNameConverter()));
    }

    @Test
    @Transactional
    public void shouldGetDirectRelationshipForType() throws Exception {
        this.assertSingleResult((Object)"rel1", (Iterable)this.neo4jTemplate.convert(this.node0.getRelationships(new RelationshipType[]{KNOWS})).to(String.class, (ResultConverter)new RelationshipNameConverter()));
    }

    @Test
    @Transactional
    public void shouldGetDirectRelationshipForTypeAndDirection() throws Exception {
        this.assertSingleResult((Object)"rel1", (Iterable)this.neo4jTemplate.convert(this.node0.getRelationships((RelationshipType)KNOWS, Direction.OUTGOING)).to(String.class, (ResultConverter)new RelationshipNameConverter()));
    }

    private <T> void assertSingleResult(T expected, Iterable<T> iterable) {
        Iterator<T> result = iterable.iterator();
        Assert.assertEquals(expected, result.next());
        Assert.assertEquals((Object)false, (Object)result.hasNext());
    }

    @Test
    @Transactional
    public void shouldCreateRelationshipWithProperty() throws Exception {
        Relationship relationship = this.neo4jTemplate.createRelationshipBetween(this.node0, this.node1, "has", MapUtil.map((Object[])new Object[]{"name", "rel2"}));
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((Object)this.node0, (Object)relationship.getStartNode());
        Assert.assertEquals((Object)this.node1, (Object)relationship.getEndNode());
        Assert.assertEquals((Object)HAS.name(), (Object)relationship.getType().name());
        Assert.assertEquals((Object)"rel2", (Object)relationship.getProperty("name", (Object)"not set"));
    }

    private static class PropertyContainerNameConverter
    extends ResultConverter.ResultConverterAdapter<PropertyContainer, String> {
        private PropertyContainerNameConverter() {
        }

        public String convert(PropertyContainer value, Class<String> type) {
            return (String)value.getProperty("name");
        }
    }

    private static class RelationshipNameConverter
    extends ResultConverter.ResultConverterAdapter<Relationship, String> {
        private RelationshipNameConverter() {
        }

        public String convert(Relationship value, Class<String> type) {
            return (String)value.getProperty("name");
        }
    }

    private static class PathNodeNameMapper
    extends ResultConverter.ResultConverterAdapter<Path, String> {
        private PathNodeNameMapper() {
        }

        public String convert(Path path, Class<String> type) {
            return (String)path.endNode().getProperty("name", (Object)"not set");
        }
    }

    private static class PathRelationshipNameMapper
    extends ResultConverter.ResultConverterAdapter<Path, String> {
        private PathRelationshipNameMapper() {
        }

        public String convert(Path path, Class<String> type) {
            return (String)path.lastRelationship().getProperty("name", (Object)"not set");
        }
    }
}

