/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import java.io.IOException;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.neo4j.config.JtaTransactionManagerFactoryBean;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.support.DelegatingGraphDatabase;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.template.GraphCallback;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class Neo4jTemplateApiTransactionTests {
    private static final DynamicRelationshipType KNOWS = DynamicRelationshipType.withName((String)"knows");
    private static final DynamicRelationshipType HAS = DynamicRelationshipType.withName((String)"has");
    protected Neo4jTemplate template;
    protected GraphDatabase graphDatabase;
    protected Node node0;
    protected Relationship relationship1;
    protected Node node1;
    protected PlatformTransactionManager transactionManager;
    protected GraphDatabaseService graphDatabaseService;

    @Before
    public void setUp() throws Exception {
        this.graphDatabaseService = this.createGraphDatabaseService();
        this.graphDatabase = this.createGraphDatabase();
        this.transactionManager = this.createTransactionManager();
        this.template = new Neo4jTemplate(this.graphDatabase, this.transactionManager);
        this.createData();
    }

    protected GraphDatabaseService createGraphDatabaseService() throws IOException {
        return new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    protected GraphDatabase createGraphDatabase() throws Exception {
        return new DelegatingGraphDatabase(this.graphDatabaseService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBeginTxWithoutConfiguredTxManager() throws Exception {
        Neo4jTemplate template = new Neo4jTemplate(this.graphDatabase);
        Transaction tx = template.getGraphDatabase().beginTx();
        Node node = template.createNode();
        node.setProperty("name", (Object)"foo");
        tx.success();
        tx.close();
        tx = template.getGraphDatabase().beginTx();
        try {
            Assert.assertNotNull((Object)node.getProperty("name"));
        }
        finally {
            tx.success();
            tx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstantiateEntity() throws Exception {
        Neo4jTemplate template = new Neo4jTemplate(this.graphDatabase, this.transactionManager);
        Transaction tx = template.getGraphDatabase().beginTx();
        try {
            Person michael = (Person)template.save((Object)new Person("Michael", 37));
            Assert.assertNotNull((Object)michael.getId());
        }
        finally {
            tx.success();
            tx.close();
        }
    }

    protected PlatformTransactionManager createTransactionManager() {
        return new JtaTransactionManagerFactoryBean(this.graphDatabaseService).getObject();
    }

    private void createData() {
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                Neo4jTemplateApiTransactionTests.this.node0 = Neo4jTemplateApiTransactionTests.this.graphDatabase.createNode(MapUtil.map((Object[])new Object[]{"name", "node0"}), Arrays.asList("Node"));
                Neo4jTemplateApiTransactionTests.this.graphDatabase.createIndex(Node.class, "node", IndexType.SIMPLE).add((PropertyContainer)Neo4jTemplateApiTransactionTests.this.node0, "name", (Object)"node0");
                Neo4jTemplateApiTransactionTests.this.node1 = Neo4jTemplateApiTransactionTests.this.graphDatabase.createNode(MapUtil.map((Object[])new Object[]{"name", "node1"}), Arrays.asList("Node"));
                Neo4jTemplateApiTransactionTests.this.relationship1 = Neo4jTemplateApiTransactionTests.this.node0.createRelationshipTo(Neo4jTemplateApiTransactionTests.this.node1, (RelationshipType)KNOWS);
                Neo4jTemplateApiTransactionTests.this.relationship1.setProperty("name", (Object)"rel1");
                Neo4jTemplateApiTransactionTests.this.graphDatabase.createIndex(Relationship.class, "relationship", IndexType.SIMPLE).add((PropertyContainer)Neo4jTemplateApiTransactionTests.this.relationship1, "name", (Object)"rel1");
            }
        });
    }

    @Test
    public void shouldExecuteCallbackInTransaction() throws Exception {
        Node refNode = (Node)this.template.exec((GraphCallback)new GraphCallback<Node>(){

            public Node doWithGraph(GraphDatabase graph) throws Exception {
                Node referenceNode = graph.getNodeById(Neo4jTemplateApiTransactionTests.this.node0.getId());
                referenceNode.setProperty("test", (Object)"testDoInTransaction");
                return referenceNode;
            }
        });
        Transaction tx = this.graphDatabase.beginTx();
        try {
            Assert.assertEquals((String)"same reference node", (Object)this.node0, (Object)refNode);
            this.assertTestPropertySet(this.node0, "testDoInTransaction");
        }
        finally {
            tx.success();
            tx.close();
        }
    }

    @Test
    public void shouldRollbackTransactionOnException() {
        try {
            this.template.exec((GraphCallback)new GraphCallback.WithoutResult(){

                public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                    Neo4jTemplateApiTransactionTests.this.node0.setProperty("test", (Object)"shouldRollbackTransactionOnException");
                    throw new RuntimeException("please rollback");
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Transaction tx = this.graphDatabase.beginTx();
        try {
            Assert.assertThat((Object)((String)this.node0.getProperty("test", (Object)"not set")), (Matcher)CoreMatchers.not((Object)"shouldRollbackTransactionOnException"));
        }
        finally {
            tx.success();
            tx.close();
        }
    }

    @Test
    public void shouldRollbackViaStatus() throws Exception {
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(final TransactionStatus status) {
                Neo4jTemplateApiTransactionTests.this.template.exec((GraphCallback)new GraphCallback.WithoutResult(){

                    public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                        Neo4jTemplateApiTransactionTests.this.node0.setProperty("test", (Object)"shouldRollbackTransactionOnException");
                        status.setRollbackOnly();
                    }
                });
            }
        });
        Transaction tx = this.graphDatabase.beginTx();
        try {
            Assert.assertThat((Object)((String)this.node0.getProperty("test", (Object)"not set")), (Matcher)CoreMatchers.not((Object)"shouldRollbackTransactionOnException"));
        }
        finally {
            tx.success();
            tx.close();
        }
    }

    @Test(expected=RuntimeException.class)
    public void shouldNotConvertUserRuntimeExceptionToDataAccessException() {
        this.template.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                throw new RuntimeException();
            }
        });
    }

    @Test(expected=DataAccessException.class)
    @Ignore
    public void shouldConvertMissingTransactionExceptionToDataAccessException() {
        Neo4jTemplate template = new Neo4jTemplate(this.graphDatabase, null);
        template.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                graph.createNode(null, null);
            }
        });
    }

    @Test(expected=DataAccessException.class)
    public void shouldConvertNotFoundExceptionToDataAccessException() {
        Neo4jTemplate template = new Neo4jTemplate(this.graphDatabase, this.transactionManager);
        template.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                graph.getNodeById(Long.MAX_VALUE);
            }
        });
    }

    @Test
    public void shouldExecuteCallback() throws Exception {
        Long refNodeId = (Long)this.template.exec((GraphCallback)new GraphCallback<Long>(){

            public Long doWithGraph(GraphDatabase graph) throws Exception {
                return graph.getNodeById(Neo4jTemplateApiTransactionTests.this.node0.getId()).getId();
            }
        });
        Transaction tx = this.graphDatabase.beginTx();
        try {
            Assert.assertEquals((long)this.node0.getId(), (long)refNodeId);
        }
        finally {
            tx.success();
            tx.close();
        }
    }

    @Test
    public void testCreateNode() throws Exception {
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                Node node = Neo4jTemplateApiTransactionTests.this.template.createNode(null);
                Assert.assertNotNull((String)"created node", (Object)node);
            }
        });
    }

    @Test
    public void testCreateNodeWithProperties() throws Exception {
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                Node node = Neo4jTemplateApiTransactionTests.this.template.createNode(MapUtil.map((Object[])new Object[]{"test", "testCreateNodeWithProperties"}));
                Neo4jTemplateApiTransactionTests.this.assertTestPropertySet(node, "testCreateNodeWithProperties");
            }
        });
    }

    private void assertTestPropertySet(Node node, String testName) {
        Assert.assertEquals((Object)testName, (Object)node.getProperty("test", (Object)"not set"));
    }
}

