/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.template.GraphCallback;
import org.springframework.data.neo4j.template.NeoApiTests;

public class Neo4jTemplateTests
extends NeoApiTests {
    private Node refNode;

    @Test
    public void testRefNode() {
        Node refNodeById = (Node)new Neo4jTemplate(this.graph, this.transactionManager).exec((GraphCallback)new GraphCallback<Node>(){

            public Node doWithGraph(GraphDatabase graph) throws Exception {
                return graph.getNodeById(Neo4jTemplateTests.this.refNode.getId());
            }
        });
        try (Transaction tx = this.graph.beginTx();){
            Assert.assertEquals((String)"same ref node", (Object)this.refNode, (Object)refNodeById);
            tx.success();
        }
    }

    @Test
    public void testSingleNode() {
        Neo4jTemplate template = new Neo4jTemplate(this.graph, this.transactionManager);
        template.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                Node node = graph.createNode(MapUtil.map((Object[])new Object[]{"name", "Test", "size", 100}), null);
                Neo4jTemplateTests.this.refNode.createRelationshipTo(node, (RelationshipType)Type.HAS);
                Relationship toTestNode = Neo4jTemplateTests.this.refNode.getSingleRelationship((RelationshipType)Type.HAS, Direction.OUTGOING);
                Node nodeByRelationship = toTestNode.getEndNode();
                Assert.assertEquals((Object)"Test", (Object)nodeByRelationship.getProperty("name"));
                Assert.assertEquals((Object)100, (Object)nodeByRelationship.getProperty("size"));
            }
        });
        template.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                Relationship toTestNode = Neo4jTemplateTests.this.refNode.getSingleRelationship((RelationshipType)Type.HAS, Direction.OUTGOING);
                Node nodeByRelationship = toTestNode.getEndNode();
                Assert.assertEquals((Object)"Test", (Object)nodeByRelationship.getProperty("name"));
                Assert.assertEquals((Object)100, (Object)nodeByRelationship.getProperty("size"));
            }
        });
    }

    @Test
    public void testRollback() {
        Neo4jTemplate template = new Neo4jTemplate(this.graph, this.transactionManager);
        try {
            template.exec((GraphCallback)new GraphCallback.WithoutResult(){

                public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                    Node node = Neo4jTemplateTests.this.refNode;
                    node.setProperty("test", (Object)"test");
                    Assert.assertEquals((Object)"test", (Object)node.getProperty("test"));
                    throw new RuntimeException();
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        template.exec((GraphCallback)new GraphCallback.WithoutResult(){

            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                Assert.assertFalse((boolean)Neo4jTemplateTests.this.refNode.hasProperty("test"));
            }
        });
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.refNode = (Node)new Neo4jTemplate(this.graph, this.transactionManager).exec((GraphCallback)new GraphCallback<Node>(){

            public Node doWithGraph(GraphDatabase graph) throws Exception {
                return graph.createNode(MapUtil.map((Object[])new Object[0]), null);
            }
        });
    }

    static enum Type implements RelationshipType
    {
        HAS;

    }
}

