/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.unique;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.Indexed;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
public class UniqueConvertedValueTests {
    @Autowired
    Neo4jTemplate template;

    @Test
    @Transactional
    public void testPersistUniqueEnumValue() throws Exception {
        Word word = (Word)this.template.save((Object)new Word(Letter.A, "Afternoon"));
        Assert.assertEquals((Object)((Object)Letter.A), (Object)((Object)word.letter));
        Assert.assertEquals((Object)"Afternoon", (Object)word.word);
    }

    @Test
    @Transactional
    public void testPersistUniqueEnumValueLegacyIndex() throws Exception {
        Word word = (Word)this.template.save((Object)new Word(Letter.A, "Afternoon"));
        Assert.assertEquals((Object)((Object)Letter.A), (Object)((Object)word.letter));
        Assert.assertEquals((Object)"Afternoon", (Object)word.word);
    }

    @NodeEntity
    static class Word2 {
        @GraphId
        Long id;
        @Indexed(unique=true, indexType=IndexType.SIMPLE)
        Letter letter;
        String word;

        Word2() {
        }

        Word2(Letter letter, String word) {
            this.letter = letter;
            this.word = word;
        }
    }

    @NodeEntity
    static class Word {
        @GraphId
        Long id;
        @Indexed(unique=true, indexType=IndexType.LABEL)
        Letter letter;
        String word;

        Word() {
        }

        Word(Letter letter, String word) {
            this.letter = letter;
            this.word = word;
        }
    }

    static enum Letter {
        A,
        B,
        C;

    }

    @Configuration
    @EnableNeo4jRepositories
    static class TestConfig
    extends Neo4jConfiguration {
        TestConfig() {
            this.setBasePackage(new String[]{"org.springframework.data.neo4j.unique"});
        }

        @Bean
        GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }
    }
}

