/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.unique.common;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.unique.common.CommonClub;
import org.springframework.data.neo4j.unique.common.CommonUniqueClub;
import org.springframework.data.neo4j.unique.common.CommonUniqueNumericIdClub;

public abstract class CommonUniqueEntityTestBase {
    @Before
    public void setup() {
        this.clearDownAllRepositories();
    }

    @Test
    public void shouldOnlyCreateSingleInstanceForUniqueNodeEntity() {
        CommonUniqueClub club1 = this.createUniqueClub("foo", null);
        CommonUniqueClub club2 = this.createUniqueClub("foo", null);
        CommonUniqueClub club3 = this.createUniqueClub("foo", null);
        Assert.assertEquals((long)1L, (long)this.getUniqueClubRepository().count());
        Assert.assertEquals((String)"Expected same node Ids", (Object)club1.getId(), (Object)club2.getId());
    }

    @Test
    public void shouldMergeNewUniqueNodeEntityDataWithExistingDataWhenSaving() {
        CommonUniqueClub club1 = this.createUniqueClub("bar", "description-1");
        CommonUniqueClub club2 = this.createUniqueClub("bar", "description-2");
        Assert.assertEquals((long)1L, (long)this.getUniqueClubRepository().count());
        Assert.assertEquals((String)"Expected same node Ids", (Object)club1.getId(), (Object)club2.getId());
        CommonUniqueClub retrievedClub = (CommonUniqueClub)this.getUniqueClubRepository().findOne((Serializable)club1.getId());
        Assert.assertEquals((String)"Description not merged as expected", (Object)"description-2", (Object)retrievedClub.getDescription());
    }

    @Test(expected=MappingException.class)
    public void shouldFailOnNullPropertyValue() {
        this.createUniqueClub(null, null);
    }

    @Test(expected=MappingException.class)
    public void shouldFailOnNullNumericPropertyValue() {
        this.createUniqueNumericClub(null);
    }

    @Test
    public void shouldOnlyCreateSingleInstanceForUniqueNumericNodeEntity() {
        CommonUniqueNumericIdClub club1 = this.createUniqueNumericClub(100L);
        CommonUniqueNumericIdClub club2 = this.createUniqueNumericClub(100L);
        Assert.assertEquals((long)1L, (long)this.getUniqueNumericIdClubRepository().count());
        Assert.assertEquals((String)"Expected same node Ids", (Object)club1.getId(), (Object)club2.getId());
    }

    @Test
    public void shouldCreateMultipleInstancesForNonUniqueNodeEntity() {
        CommonClub club1 = this.createNonUniqueClub("foo");
        CommonClub club2 = this.createNonUniqueClub("foo");
        Assert.assertEquals((long)2L, (long)this.getClubRepository().count());
        Assert.assertNotEquals((String)"Expected different node Ids", (Object)club1.getId(), (Object)club2.getId());
    }

    @Test
    public void deletingUniqueNodeShouldRemoveItFromTheUniqueIndex() {
        CommonUniqueClub club1 = this.createUniqueClub("foo", null);
        Assert.assertEquals((String)"Expected one unique entity", (long)1L, (long)this.getUniqueClubRepository().count());
        this.getUniqueClubRepository().delete((Object)club1);
        Assert.assertEquals((String)"Expected zero unique entities", (long)0L, (long)this.getUniqueClubRepository().count());
    }

    @Test(expected=DataIntegrityViolationException.class)
    public void updatingToADuplicateValueShouldCauseAnException() {
        CommonUniqueClub club1 = this.createUniqueClub("foo", "foo description");
        CommonUniqueClub club2 = this.createUniqueClub("bar", "bar description");
        Assert.assertEquals((long)2L, (long)this.getUniqueClubRepository().count());
        Assert.assertNotEquals((String)"Expected different node Ids", (Object)club1.getId(), (Object)club2.getId());
        club2.setName("foo");
        this.getUniqueClubRepository().save((Object)club2);
    }

    @Test
    public void updatingToANewValueShouldAlsoUpdateTheIndex() {
        CommonUniqueClub club1 = this.createUniqueClub("foo", "foo description");
        Assert.assertEquals((long)1L, (long)this.getUniqueClubRepository().count());
        CommonUniqueClub fooClub = this.lookupEntityByUniquePropertyValue("name", "foo");
        Assert.assertNotNull((Object)fooClub);
        Assert.assertEquals((Object)club1.getId(), (Object)fooClub.getId());
        club1.setName("bar");
        this.getUniqueClubRepository().save((Object)club1);
        Assert.assertEquals((long)1L, (long)this.getUniqueClubRepository().count());
        CommonUniqueClub currentClub = this.lookupEntityByUniquePropertyValue("name", "bar");
        Assert.assertNotNull((Object)currentClub);
        Assert.assertEquals((Object)club1.getId(), (Object)currentClub.getId());
        CommonUniqueClub redundantClub = this.lookupEntityByUniquePropertyValue("name", "foo");
        Assert.assertNull((Object)redundantClub);
    }

    @Test
    public void updatingToANewValueShouldKeepTheEntityUnique() {
        CommonUniqueClub club1 = this.createUniqueClub("foo", "foo description");
        Assert.assertEquals((long)1L, (long)this.getUniqueClubRepository().count());
        CommonUniqueClub fooClub = this.lookupEntityByUniquePropertyValue("name", "foo");
        Assert.assertNotNull((Object)fooClub);
        Assert.assertEquals((Object)club1.getId(), (Object)fooClub.getId());
        club1.setName("bar");
        this.getUniqueClubRepository().save((Object)club1);
        Assert.assertEquals((long)1L, (long)this.getUniqueClubRepository().count());
        CommonUniqueClub currentClub = this.lookupEntityByUniquePropertyValue("name", "bar");
        Assert.assertNotNull((Object)currentClub);
        Assert.assertEquals((Object)club1.getId(), (Object)currentClub.getId());
        CommonUniqueClub redundantClub = this.lookupEntityByUniquePropertyValue("name", "foo");
        Assert.assertNull((Object)redundantClub);
    }

    @Ignore(value="This scenario does not work, could be transactional issues")
    @Test
    public void updatingToANewValueShouldKeepTheEntityUniqueAndOldValueShouldBeReusableThereafter() {
        this.updatingToANewValueShouldAlsoUpdateTheIndex();
        CommonUniqueClub currentClub = (CommonUniqueClub)this.getUniqueClubRepository().findBySchemaPropertyValue("name", (Object)"bar");
        Assert.assertNotNull((Object)currentClub);
        CommonUniqueClub redundantClub = (CommonUniqueClub)this.getUniqueClubRepository().findBySchemaPropertyValue("name", (Object)"foo");
        Assert.assertNull((Object)redundantClub);
        CommonUniqueClub fooReusingClub = this.createUniqueClub("foo", "foo description");
        Assert.assertNotEquals((String)"A new id should have been created for re-use of foo but it was not!", (Object)currentClub.getId(), (Object)fooReusingClub.getId());
        Assert.assertEquals((long)2L, (long)this.getUniqueClubRepository().count());
    }

    protected abstract CommonUniqueClub lookupEntityByUniquePropertyValue(String var1, Object var2);

    protected abstract void clearDownAllRepositories();

    protected abstract CommonUniqueClub createUniqueClub(String var1, String var2);

    protected abstract CommonUniqueNumericIdClub createUniqueNumericClub(Long var1);

    protected abstract CommonClub createNonUniqueClub(String var1);

    protected abstract GraphRepository getUniqueNumericIdClubRepository();

    protected abstract GraphRepository getUniqueClubRepository();

    protected abstract GraphRepository getClubRepository();
}

