/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.unique.legacy;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.unique.common.CommonClub;
import org.springframework.data.neo4j.unique.common.CommonUniqueClub;
import org.springframework.data.neo4j.unique.common.CommonUniqueEntityTestBase;
import org.springframework.data.neo4j.unique.common.CommonUniqueNumericIdClub;
import org.springframework.data.neo4j.unique.legacy.domain.Club;
import org.springframework.data.neo4j.unique.legacy.domain.UniqueClub;
import org.springframework.data.neo4j.unique.legacy.domain.UniqueNumericIdClub;
import org.springframework.data.neo4j.unique.legacy.repository.ClubRepository;
import org.springframework.data.neo4j.unique.legacy.repository.UniqueClubRepository;
import org.springframework.data.neo4j.unique.legacy.repository.UniqueNumericIdClubRepository;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:unique-legacy-test-context.xml"})
@Transactional
public class UniqueLegacyIndexBasedEntityTests
extends CommonUniqueEntityTestBase {
    @Autowired
    private Neo4jTemplate neo4jTemplate;
    @Autowired
    private ClubRepository clubRepository;
    @Autowired
    private UniqueClubRepository uniqueClubRepository;
    @Autowired
    protected GraphDatabaseService graphDatabaseService;
    @Autowired
    private UniqueNumericIdClubRepository uniqueNumericIdClubRepository;

    @Override
    @Before
    public void setup() {
        super.setup();
    }

    @Override
    protected void clearDownAllRepositories() {
        this.uniqueClubRepository.deleteAll();
        this.clubRepository.deleteAll();
        this.uniqueClubRepository.deleteAll();
    }

    @Override
    @Test(expected=DataIntegrityViolationException.class)
    public void shouldOnlyCreateSingleInstanceForUniqueNumericNodeEntity() {
        CommonUniqueNumericIdClub club1 = this.createUniqueNumericClub(100L);
        CommonUniqueNumericIdClub club2 = this.createUniqueNumericClub(100L);
        Assert.assertEquals((long)1L, (long)this.getUniqueNumericIdClubRepository().count());
        Assert.assertEquals((String)"Expected same node Ids", (Object)club1.getId(), (Object)club2.getId());
    }

    @Test
    public void creatingDistinctUniqueEntitiesViaNeo4jTemplateShouldResolveToDifferentEntities() {
        List<String> labels = Arrays.asList(UniqueClub.class.getSimpleName(), "_" + UniqueClub.class.getSimpleName());
        HashMap<String, String> fooParams = new HashMap<String, String>();
        fooParams.put("name", "foo");
        fooParams.put("description", "foo description");
        HashMap<String, String> barParams = new HashMap<String, String>();
        barParams.put("name", "bar");
        barParams.put("description", "foo description");
        Node club1 = this.neo4jTemplate.getOrCreateNode(UniqueClub.class.getSimpleName(), "name", (Object)"foo", fooParams, labels);
        Node club2 = this.neo4jTemplate.getOrCreateNode(UniqueClub.class.getSimpleName(), "name", (Object)"bar", barParams, labels);
        Assert.assertNotEquals((String)"Expected different node Ids", (long)club1.getId(), (long)club2.getId());
        Assert.assertEquals((long)2L, (long)this.getUniqueClubRepository().count());
    }

    @Test
    public void creatingTheSameUniqueEntitiesViaNeo4jTemplateShouldResolveToOriginalEntity() {
        List<String> labels = Arrays.asList(UniqueClub.class.getSimpleName(), "_" + UniqueClub.class.getSimpleName());
        HashMap<String, String> fooParams = new HashMap<String, String>();
        fooParams.put("name", "foo");
        fooParams.put("description", "foo description");
        HashMap<String, String> foo2Params = new HashMap<String, String>();
        foo2Params.put("name", "foo");
        foo2Params.put("description", "bar description");
        Node club1 = this.neo4jTemplate.getOrCreateNode(UniqueClub.class.getSimpleName(), "name", (Object)"foo", fooParams, labels);
        Node club2 = this.neo4jTemplate.getOrCreateNode(UniqueClub.class.getSimpleName(), "name", (Object)"foo", foo2Params, labels);
        Assert.assertEquals((String)"Expected the same node Ids", (long)club1.getId(), (long)club2.getId());
        Assert.assertEquals((long)1L, (long)this.getUniqueClubRepository().count());
        Assert.assertEquals((Object)"foo description", (Object)club2.getProperty("description"));
    }

    @Override
    protected CommonClub createNonUniqueClub(String name) {
        Club club = new Club();
        club.setName(name);
        this.clubRepository.save(club);
        return club;
    }

    @Override
    protected CommonUniqueClub createUniqueClub(String name, String description) {
        UniqueClub club = new UniqueClub();
        club.setName(name);
        club.setDescription(description);
        this.uniqueClubRepository.save(club);
        return club;
    }

    @Override
    protected CommonUniqueNumericIdClub createUniqueNumericClub(Long clubId) {
        UniqueNumericIdClub club = new UniqueNumericIdClub();
        club.setClubId(clubId);
        this.uniqueNumericIdClubRepository.save(club);
        return club;
    }

    @Override
    protected CommonUniqueClub lookupEntityByUniquePropertyValue(String propertyName, Object value) {
        return (CommonUniqueClub)this.getUniqueClubRepository().findByPropertyValue(propertyName, value);
    }

    @Override
    protected GraphRepository getUniqueNumericIdClubRepository() {
        return this.uniqueNumericIdClubRepository;
    }

    @Override
    protected GraphRepository getUniqueClubRepository() {
        return this.uniqueClubRepository;
    }

    @Override
    protected GraphRepository getClubRepository() {
        return this.clubRepository;
    }
}

