/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.test.snippets;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Direction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.test.DocumentingTestBase;
import org.springframework.data.test.snippets.GroupRepository;
import org.springframework.data.test.snippets.PersonRepository;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath*:DocumentingTests-context.xml"})
public class SnippetRepositoryDerivedFinderTests
extends DocumentingTestBase {
    @Autowired
    Neo4jTemplate template;
    @Autowired
    PersonRepository personRepository;
    @Autowired
    GroupRepository groupRepository;

    @Test
    @Transactional
    public void documentDerivedFinders() {
        this.title = "Derived Finder Methods";
        this.paragraphs = new String[]{"Use the meta information of your domain model classes to declare repository finders that navigate along relationships and compare properties. The path defined with the method name is used to create a Cypher query that is executed on the graph."};
        this.snippetTitle = "Repository and usage of derived finder methods";
        this.snippet = "derived";
        Person oliver = (Person)this.personRepository.save(new Person("Oliver"));
        Group springData = new Group("spring-data", oliver);
        this.groupRepository.save(springData);
        Iterable<Person> members = this.personRepository.findByGroupTitle("spring-data");
        Assert.assertThat((Object)members.iterator().next().name, (Matcher)Is.is((Object)oliver.name));
    }

    @NodeEntity
    public static class Group {
        @GraphId
        Long id;
        private String title;
        @RelatedTo(type="group", direction=Direction.INCOMING)
        private Set<Person> members = new HashSet<Person>();

        private Group() {
        }

        public Group(String title, Person ... people) {
            this.title = title;
            this.members.addAll(Arrays.asList(people));
        }
    }

    @NodeEntity
    public static class Person {
        @GraphId
        Long id;
        private String name;
        private Group group;

        private Person() {
        }

        public Person(String name) {
            this.name = name;
        }
    }
}

