/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repositories;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.repositories.context.RepositoriesTestContext;
import org.springframework.data.neo4j.repositories.domain.Movie;
import org.springframework.data.neo4j.repositories.repo.MovieRepository;
import org.springframework.data.neo4j.util.IterableUtils;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(classes={RepositoriesTestContext.class})
@RunWith(value=SpringJUnit4ClassRunner.class)
public class RepositoryDefinitionTest
extends MultiDriverTestClass {
    private GraphDatabaseService graphDatabaseService = RepositoryDefinitionTest.getGraphDatabaseService();
    @Autowired
    private Session session;
    @Autowired
    private MovieRepository movieRepository;

    @Before
    public void init() {
        this.session.purgeDatabase();
    }

    @Test
    public void shouldProxyAndAutoImplementRepositoryDefinitionAnnotatedRepo() {
        Movie movie = new Movie("PF");
        this.movieRepository.save(movie);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)this.graphDatabaseService, (String)"CREATE (m:Movie {title:'PF'})");
        Assert.assertEquals((long)1L, (long)IterableUtils.count(this.movieRepository.findAll()));
    }
}

