/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template.context;

import org.neo4j.ogm.session.SessionFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.event.AfterDeleteEvent;
import org.springframework.data.neo4j.event.AfterSaveEvent;
import org.springframework.data.neo4j.event.BeforeDeleteEvent;
import org.springframework.data.neo4j.event.BeforeSaveEvent;
import org.springframework.data.neo4j.template.TestNeo4jEventListener;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class DataManipulationEventConfiguration
extends Neo4jConfiguration {
    public SessionFactory getSessionFactory() {
        return new SessionFactory(new String[]{"org.springframework.data.neo4j.examples.movies.domain"});
    }

    @Bean
    public ApplicationListener<BeforeSaveEvent> beforeSaveEventListener() {
        return new TestNeo4jEventListener<BeforeSaveEvent>(){};
    }

    @Bean
    public ApplicationListener<AfterSaveEvent> afterSaveEventListener() {
        return new TestNeo4jEventListener<AfterSaveEvent>(){};
    }

    @Bean
    public ApplicationListener<BeforeDeleteEvent> beforeDeleteEventListener() {
        return new TestNeo4jEventListener<BeforeDeleteEvent>(){};
    }

    @Bean
    public ApplicationListener<AfterDeleteEvent> afterDeleteEventListener() {
        return new TestNeo4jEventListener<AfterDeleteEvent>(){};
    }
}

